Ext.define('Academia.view.securitysetup.UserPasswordPolicy',{
	extend : 'Ext.form.FormPanel',
	alias:'widget.userpasswordpolicy',
	autoScroll:true,
	modal : true,
    plugins: "formlabelrequired",
    cls:'x-form-fixed-footer-parent',
	items:[{
		xtype:'panel',
		frame:true,
		title:getCommonTranslation('USER_PASSWORD_POLICY'),
		style:{
	    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	    },
		items:[{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'hidden',
			name:'version'
		},{
			xtype : 'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items : [{
				xtype:'numberfield',
				name:'minLength',
				fieldLabel:getCommonTranslation('MIN_LENGTH_PASSWORD'),
				//allowBlank:false,
				minValue : 0,
				allowExponential: false,
				allowDecimals: false
			},{
				xtype:'numberfield',
				name:'maxLength',
				fieldLabel:getCommonTranslation('MAX_LENGTH_PASSWORD'),
				//allowBlank:false,
				minValue : 0,
				allowExponential: false,
				allowDecimals: false
			}
			]},{
				xtype : 'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items : [{
					xtype:'numberfield',
					name:'minSpecialCharacter',
					fieldLabel:getCommonTranslation('MIN_SPECIAL_CHARACTER'),
					//allowBlank:false
					minValue : 0
					
				},{
					xtype:'numberfield',
					name:'minDigits',
					fieldLabel:getCommonTranslation('MIN_DIGITS'),
					//allowBlank:false,
					minValue : 0
				}]},{
						xtype : 'fieldcontainer',
						layout:'hbox',
						width:'100%',
						defaults: {
							width: 256,
							labelAlign: 'top'
						},
						items : [{
							xtype:'numberfield',
							name:'minCapitalLetter',
							fieldLabel:getCommonTranslation('MIN_CAPITAL_LETTERS'),
							//allowBlank:false,
							minValue : 0
						},{
							xtype:'textfield',
							name:'allowableSpecialCharacters',
							fieldLabel:getCommonTranslation('ALLOWABLE_SPECIAL_LETTERS'),
						//	allowBlank:false,
							minValue : 0,
							maskRe:/^[!@#\$%\^\&*\)\(+=._-]+$/g
						}
						]},/*{
		xtype:'numberfield',
		name:'minDigits',
		fieldLabel:getCommonTranslation('MIN_DIGITS')
	},*/{
					xtype:'checkbox',
					name:'whetherReusePassword',
					boxLabel:getCommonTranslation('REUSE_PASSWORD'),
					inputValue: true,
					uncheckedValue: false,
					allowBlank:false
				},{
					xtype:'checkbox',
					name:'whetherReuseUsername',
					boxLabel:getCommonTranslation('REUSE_USERNAME'),
					inputValue: true,
					uncheckedValue: false,
					allowBlank:false
				},{
					xtype : 'fieldcontainer',
					layout:'hbox',
					width:'100%',
					defaults: {
						width: 256,
						labelAlign: 'top'
					},
					items : [{
						xtype:'checkbox',
						name:'whetherPasswordExpires',
						boxLabel:getCommonTranslation('PASSWORD_EXPIRES_AFETR'),
						inputValue: true,
						checked:true,
						uncheckedValue: false,
						allowBlank:false,
						listeners: {
			                change : function( checkBox, newValue, oldValue, eOpts ) {
			                	var field=this.nextSibling();
			                	field.allowBlank = !newValue;
			                	field.setVisible(newValue);
			                	field.setDisabled(!newValue);
			                	field.validate();
			                }
		                }
					},{
						xtype:'numberfield',
						name:'maxPasswordAge',
						fieldLabel:getCommonTranslation('MAX_PASSWORD_AGE'),
						allowBlank:false,
						minValue : 0
					}
					]},{
						xtype : 'fieldcontainer',
						layout:'hbox',
						width:'100%',
						defaults: {
							width: 256,
							labelAlign: 'top'
						},
						items : [{
							xtype:'checkbox',
							name:'whetherTemporaryLock',
							boxLabel:getCommonTranslation('LOCK_USER_AFETR'),
							inputValue: true,
							 checked:true,
							uncheckedValue: false,
							listeners: {
				                change : function( checkBox, newValue, oldValue, eOpts ) {
				                	var field=this.nextSibling();
				                	field.allowBlank = !newValue;
				                	field.setVisible(newValue);
				                	field.setDisabled(!newValue);
				                	field.validate();
				                }
			                }
						},{
							xtype:'numberfield',
							name:'unsuccessfulAttempts',
							fieldLabel:getCommonTranslation('UNSUCCESSFUL_ATTEMPTS'),
							allowBlank:false,
							minValue : 0
						}]},{
							xtype:'checkbox',
							name:'whetherUserForceToUpdatePassword',
							boxLabel:getCommonTranslation('FORCE_UPDATE_PASSWORD'),
							inputValue: true,
							uncheckedValue: false,
							allowBlank:false,
						},{
							xtype:'checkbox',
							name:'whetherUnlockOnPasswordReset',
							boxLabel:getCommonTranslation('UNLOCK_ON_RESET'),
							inputValue: true,
							uncheckedValue: false,
							allowBlank:false,
							/*style:{
								marginTop:'30px'
							}*/
						},{
							xtype:'fieldcontainer',
							cls:'form-fixed-footer',
							items:[{
								xtype:'button',
								text:getCommonTranslation('SAVE'),
								itemId:'submitBtn',
								formBind : true,
								action:'save',
								//align:'right',
								ui:'CustomBtnSubmit',
								scale:CONSTANTS.BUTTONSIZE
							},{
					            xtype: 'button',
					            text: getServiceRequestTranslation('CLEAR_SEARCH'),
					            itemId: 'clearSearch',
					            buttonAlign: 'right',
					            ui: 'CustomBtnCancel',
					            scale: CONSTANTS.BUTTONSIZE,
					           /* handler : function(){
					            	this.up('form').getForm().reset();
					            }*/
					        }]
						}]
}]

});