/**
 * @author pritam.patil
 * this form is used for student track request
 */
Ext.define('Academia.view.servicerequest.FindRequestForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.findrequestform',
    frame: false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'radiogroup',
        itemId: 'requestFor',
        name:'REQUEST_FOR',
        layout:'hbox',
        items: [{
            boxLabel: getServiceRequestTranslation('All_REQUESTS'),
            name: 'requestFor',
            itemId:'allRequest',
            inputValue: 'All_REQUESTS',
            checked: true,
            margin:'0 20 0 0',
            style: 'font-weight: bold;'

        },{
            boxLabel: getServiceRequestTranslation('MY_REQUESTS'),
            name: 'requestFor',
            itemId:'myRequest',
            inputValue: 'MY_REQUESTS',
            margin:'0 20 0 0',
            style: 'font-weight: bold;'
        },{
            boxLabel: getServiceRequestTranslation('TRANSFER_IN_REQUESTS'),
            name: 'requestFor',
            itemId:'transferInRequests',
            inputValue: 'TRANSFER_IN_REQUESTS',
            style: 'font-weight: bold;'
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
    		xtype: 'multiselectcombofield',
    		width: 700,
    		height:58,
    		name: 'transferringOutAL',
    		itemId: 'transferringOutAL',
    		allowBlank : false,
    		fieldLabel : getCommonTranslation('TRANSFERRING_OUT_ACADEMY_LOCATION'),
    		store:'common.AcademyLocationNameSeparated',
    		cls:'multiBrandCampusCls',
    		displayField:'value',
    		valueField:'id',
    		matchFieldWidth:true,
    		maxLength:15000,
    		autoloadStore: false,
    		queryMode:'local',
    		hidden:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.width = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{code}' +
    				'</div>';
    			}
    		}
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
				xtype: 'customcombobox',
				name: 'REQUEST_ID',
				fieldLabel: getServiceRequestTranslation('REQUEST_ID'),
				store: 'servicerequest.studentservicerequest.StudentRequestStore',
				itemId: 'request_id',
		        msgTarget: 'qtip',
				valueField: 'code',
				displayField: 'code',
				queryParam:'serviceRequestNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
            	
        }/*,{
            xtype: 'customcombobox',
            name: 'STUDENT_STATUS',
            fieldLabel: getServiceRequestTranslation('SERVICE_REQUEST_STATUS'),
            itemId: 'student_portal_status',
            editable: false,
            hidden:true,
            store: 'servicerequest.common.ServiceRequestStatus',
            displayField: 'value',
            valueField: 'id',
            msgTarget: 'qtip'
        }*/,{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('REQUESTERS_TYPE'),
            store: 'servicerequest.common.RequesterTypes',
            editable: false,
            queryMode: 'local',
            name: 'selectedNameField',
            itemId: 'selectedNameField',
            valueField: 'id',
            displayField: 'value',
            readOnly:true,
            value: 'STUDENT'
       },{
			xtype: 'customcombobox',
			name: 'STUDENT_ID',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: 'servicerequest.common.ServiceRequestStudentStore',
			itemId: 'student_id',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
       
       }]
     },{
         xtype: 'fieldcontainer',
         width: '100%',
         layout: {
             type: 'hbox'
         },
         defaults: {
             width: 256,
             labelAlign: 'top'
         },
         items: [{
             xtype: 'customcombobox',
             name: 'REQUESTER_TYPE',
             fieldLabel: getServiceRequestTranslation('REQUEST_BY'),
             itemId: 'requester_type',
             editable: false,
           //  store: 'servicerequest.common.RequesterTypes',
             store: 'servicerequest.common.RequesterBy',
             displayField: 'value',
             valueField: 'id',
             queryMode: 'local',
             msgTarget: 'qtip'
         },{
             xtype: 'customcombobox',
             name: 'assigneeId',
             itemId: 'assigneeId',
             fieldLabel: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
             store: 'servicerequest.servicerequestsettings.RequestAssignedUserStore',
             displayField: 'printName',
             valueField: 'id',
             triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
             queryParam:'term',
  			minChars:3,
//  			disabled:true,
  			enableKeyEvents  : 'true',
  			hideTrigger:false,
  			forceSelection:true,
  			hidden:false,
  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
  			listConfig: {
  				loadingText: getCommonTranslation('SEARCHING'),
  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  				getInnerTpl: function() {
  					return '<div class="search-item">' +
  					'{value}' +
  					'</div>';
  				},
  				listeners: {
  					beforeshow: function(picker) {
  						picker.minWidth = picker.up('combobox').getSize().width;
  					}
  				},
  			}
         },{
             xtype: 'customcombobox',
             name: 'STATUS',
             fieldLabel: getServiceRequestTranslation('SERVICE_REQUEST_STATUS'),
             itemId: 'status',
             editable: false,            
             store: 'servicerequest.common.ServiceRequestStatus',
             displayField: 'value',
             valueField: 'id',
             msgTarget: 'qtip'
         }/*,{
             xtype: 'customcombobox',
             fieldLabel: getPersonModuleTranslation('REQUESTER_NAME'),
             store: 'common.picklist.StudentSelectNameComboStore',
             editable: false,
             hidden:true,
             queryMode: 'local',
             name: 'selectedNameField',
             itemId: 'selectedNameField',
             valueField: 'id',
             displayField: 'value',
             value: 'FIRST_NAME'
        }*/,{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
            itemId: 'selectedName',
            hidden:true,
            name: 'REQUESTER_FIRSTNAME'
       }]
     },{
         xtype: 'requestsubrequesttypefieldcontainer',
         itemId: 'requestTypeFieldContainer',
         layout:'hbox'
     },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'numberfield',
            name: 'SLA_DAYS',
            fieldLabel: getServiceRequestTranslation('BEYOND_SLA'),
            itemId: 'beyond_SLA',
            msgTarget: 'qtip',
            minValue:'0'
        }, {
            xtype: 'datefield',
            name: 'FROM_DATE',
            fieldLabel: getServiceRequestTranslation('FROM_DATE'),
            itemId: 'from_date',
            msgTarget: 'qtip',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	        endDateField : 'till_date',
	        vtype : 'daterange'
        }, {
            xtype: 'datefield',
            name: 'TILL_DATE',
            fieldLabel: getServiceRequestTranslation('TO_DATE'),
            itemId: 'till_date',
            msgTarget: 'qtip',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	        startDateField : 'from_date',
	        vtype : 'daterange'
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('SEARCH'),
            itemId: 'findButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});