/*
 * RequestActionLevelWindow @Raghavendra.Soni.
 */
Ext.define('Academia.view.servicerequest.RequestActionLevelWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.requestactionlevelwindow',
	title : getCommonTranslation('REQUEST_ACTION_LEVEL'),
	autoScroll : true,
	height : 620,
	modal : true,
	minWidth: 565,
	items : [ {
		xtype : 'form',
		columns : 2,
		defaults : {
			labelAlign : 'top',
			width: 256
		},
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [{
                xtype: 'multiselectcombofield',
                name: 'recommendedConcessions',
                itemId: 'recommendedConcessions',
                allowBlank:false,
                fieldLabel: getCommonTranslation('THE_FOLLOWING_CONCESSIONS_ARE_RECOMMENDED'),
                store: Ext.create('Academia.store.servicerequest.common.ExamConcessionStore'),
                valueField: 'id',
                displayField: 'examConcessionName',
                forceSelection: true,
                editable: false,
                width: 400,
                allSelector: false,
                cls:'commonAutoHeightMultiselectField'
			},{
				xtype : 'button',
				text : getCommonTranslation('ADD'),
				itemId : 'recommendedConcessionsAddBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				cls: 'recommendedConcessionsAddBtnCls'
			}]
		}, {
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'label',
				text: getCommonTranslation('EXAM_CONCESSION'),
				width: 400
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			layout : {
				type : 'vbox'
			},
			itemId: 'examConcessionFieldContainer',
			items : []
		}, {
			xtype : 'fieldcontainer',
			width : 'auto',
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype: 'label',
				text: getCommonTranslation('EXAM_CONCESSION_DURATION'),
				width: 400
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'datefield',
				name : 'startDate',
				vtype : 'daterange',
				itemId : 'startDate',
				endDateField : 'tillDate',
				allowBlank : false,
				editable : true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				fieldLabel : getCommonTranslation('START_DATE')
			}, {
				xtype : 'datefield',
				name : 'tillDate',
				itemId : 'tillDate',
				vtype : 'daterange',
				startDateField : 'startDate',
				editable : true,
				minValue : new Date(),
				allowBlank : false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				fieldLabel : getCommonTranslation('END_DATE')
			} ]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'datefield',
				name : 'plannedActionDate',
				vtype : 'daterange',
				itemId : 'plannedActionDate',
				endDateField : 'actualActionDate',
				allowBlank : false,
				editable : true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				fieldLabel : getCommonTranslation('PLANNED_ACTION_DATE'),
				readOnly: true
			}, {
				xtype : 'datefield',
				name : 'actualActionDate',
				itemId : 'actualActionDate',
				vtype : 'daterange',
				startDateField : 'plannedActionDate',
				editable : true,
				minValue : new Date(),
				allowBlank : false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				fieldLabel : getCommonTranslation('ACTUAL_ACTION_DATE'),
				readOnly: true
			} ]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width: 256
			},
			layout : {
				type : 'hbox'
			},
			items : [{
             xtype: 'customcombobox',
             fieldLabel: getCommonTranslation('REQUEST_ACTION_STATUS'),
             itemId: 'requestActionStatus',
             editable: false,
             name: 'requestActionStatus',
             store: Ext.create('Ext.data.ArrayStore', {
            	 fields: ['id','code','value']
             }),
             displayField: 'value',
             valueField: 'id',
             queryMode: 'local'
         }, {
				xtype : 'textfield',
				name : 'approverName',
				itemId: 'approverName',
				allowBlank : false,
				fieldLabel : getCommonTranslation('APPROVER_NAME'),
				readOnly: true
			} , {
				xtype : 'hidden',
				name : 'approverNameId',
				itemId: 'approverNameId',
				allowBlank : false
			} ]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [ {
				xtype : 'textarea',
				name : 'remarks',
				itemId: 'remarksField',
				//allowBlank : false,
				fieldLabel : getCommonTranslation('REMARKS'),
				width: 536,
				//height: 100,
				maxLength: 1000
			} ]
		}, {
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('SAVE'),
				itemId : 'requestActionFormSubmitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'requestActionFormCancelBtn',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
	} ]

});