/**
 * @author pritam.patil
 *  Execution Details Panel 
 */
Ext.define('Academia.view.servicerequest.certificateissuerequest.CertificateExecutionDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.certificateexecutiondetailspanel',
    title: getServiceRequestTranslation('EXECUTION_DETAILS'),
    collapsible: true,
    plugins : "formlabelrequired",
    style :{
    	marginLeft : '16px'
    },
    frame : true,
    autoScroll: true,
        items: [{
        xtype: 'fieldcontainer',
        layout: {
        	type: 'vbox'
        },
        defaults: {
            width: 235,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'displayfield',
            itemId: 'user',
            fieldLabel: getServiceRequestTranslation('USER_ID'),
            name: 'userId'
        },{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('REQUEST_EXECUTED_ON'),
            name: 'executionDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'executionDateId',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
             //Select from time
        },{
            xtype: 'nestedJsonCombo',
            fieldLabel: getServiceRequestTranslation('REQUEST_HANDOVER_MODE'),
            name: 'handoverMode',
            itemId: 'requestHandover_Mode',
            editable: false,
            
            store: 'servicerequest.certificateissuerequest.HandoverMode',
            displayField: 'value',
            valueField: 'id',
            allowBlank: false
        },{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('CERTIFICATE_HANDOVER_DATE'),
            name: 'handoverDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'executionDateId',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false
             //Select from time
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CLOSURE_REASON'),
            name: 'closureReasonId',
            store: 'servicerequest.common.ClosureReasons',
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            editable: false
           // querymode : 'local'
        },{
            xtype: 'textareafield',
            name: 'remark',
            allowBlank: false,
            fieldLabel: getServiceRequestTranslation('CLOSURE_RREMARKS')
        }]
          },{
              xtype: 'fieldcontainer',
              width : '100%',
              layout: {
              	type: 'hbox'
              },
              items: [
        	  {
                  xtype: 'button',
                  text: getServiceRequestTranslation('SUBMIT'),
                  ui: 'CustomBtnSubmit',
                  itemId: 'certificateSubmitBtn',
                  scale: CONSTANTS.BUTTONSIZE,
                  hidden:true,
                  formBind: true
        	  }, {
                  xtype: 'button',
                  text: getServiceRequestTranslation('PRINT_CERTIFICATE'),
                  ui: 'CustomBtnSubmit',
                  itemId: 'printSubmitBtn',
                  scale: CONSTANTS.BUTTONSIZE,
                  formBind: true
//                  hidden:true
        	  }]
          }]
});