/**
 * @author pritam.patil
 *  basic Details Panel 
 */
Ext.define('Academia.view.servicerequest.common.BasicDetails', {
    extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.basicdetails',
    margin: '0 0 0 -10',
    items: [{
        xtype: 'fieldset',
        title: getServiceRequestTranslation('BASIC_DETAILS'),
        collapsed: false,
        items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        xtype: 'displayfield',
        itemId: 'enteredBy',
        fieldLabel: getServiceRequestTranslation('ENTERED_BY'),
        name: 'enteredBy'
    }, {
        xtype: 'displayfield',
        itemId: 'assignedTo',
        fieldLabel: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
        name: 'requestAssignedTo'
    },{
    	xtype: 'displayfield',
    	itemId: 'instructionsReqItemId',
    	fieldLabel: getServiceRequestTranslation('INSTRUCTIONS'),
    	name: 'instructionsRaise',
    	width: 536,
    	hidden:true
    }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        xtype: 'customcombobox',
        fieldLabel: getServiceRequestTranslation('REQUEST_BY'),
        name: 'requesterType',
        itemId: 'requesterTypeItemId',
        store: 'servicerequest.common.RequestBy',
        valueField: 'value',
        displayField: 'name', 
        allowBlank: false,
        editable: false,
        querymode: 'local'
    },
    {
    	xtype: 'datefield',
        fieldLabel: getServiceRequestTranslation('REQUEST_DATE'),
        name: 'requestDate',
      //--submitFormat: CONSTANTS.DATE_FORMAT,
        itemId: 'RequestDate',
        //value: new Date(),
        listeners: {
        	render: function(field) {
        		field =  dateFormatRender(field);	
        		field.setValue(new Date());
        	}
        },
        allowBlank: false,
        minValue: new Date()
      },
      {
          xtype: 'customcombobox',
          fieldLabel: getServiceRequestTranslation('ACADEMIC_TERM'),
          name: 'academicTermProgramWithdrwan',
          store: 'common.StudentJouneryAcademicTermStore',
          valueField: 'id',
          itemId: 'academicTermProgramWithdrwanId',
          displayField: 'value',
          editable: false,
          hidden : true,
          queryMode: 'local'
      },{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('EFFECTIVE_WITHDRAWAL_PROGRAM_DATE'),
            name: 'withdrawDate',
            itemId: 'withdrawDateId',
            width: 246,
            listeners: {
                render: function(field) {
                    field = dateFormatRender(field);                        
                field.setValue(new Date());
                    
                }
            },
            //allowBlank: false,
            minValue: new Date(),
           // maxValue:new Date()
          }]
    },
    {
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		height:66,
    		width:'auto'
    	},
    	items: [{
    		xtype      : 'radiogroup',
    		fieldLabel : getCommonTranslation('LEAVING_TO'),
    		itemId: 'leavingToItemId',
    		width:600,
    		hidden:true,
    		name: 'leavingTo',
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		items:[{ 
    			boxLabel: getCommonTranslation('PRIVATE_SCHOOL'), 
    			name: 'leavingTo', 
    			inputValue: 'PRIVATESCHOOL',
    			width:200
    		},{ 
    			boxLabel: getCommonTranslation('PUBLIC_SCHOOL'), 
    			name: 'leavingTo', 
    			inputValue: 'PUBLICSCHOOL',
    			width:200
    		},
    		{ 
    			boxLabel: getCommonTranslation('UNKNOWN'), 
    			name: 'leavingTo', 
    			inputValue: 'UNKNOWN',
    			width:200,
    			checked:true
    		}]
    	}]

    },
    {
    	xtype: 'fieldcontainer',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 256,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'textfield',
    		fieldLabel: getCommonTranslation('SCHOOL_LEAVING_TO'),
    		name: 'schoolLeavingTo',
    		itemId:'schoolLeavingToId',			
    		allowBlank: true,
    		hidden:true
    	}]
    },{
		 xtype: 'fieldcontainer',
		 layout: {
			 type: 'hbox'
		 },
		 defaults: {
			 width: 256,
			 labelAlign: 'top'
		 },
		 items: [{
			 xtype: 'nestedJsonCombo',
			 name:'reasonForLeaving',
			 itemId:'reasonForLeavingItemId',
			 fieldLabel:getCommonTranslation('REASON_FOR_LEAVING'),
			 store:'servicerequest.studentservicerequest.ReasonForLeavingStore',
			 valueField: 'id',
			 displayField: 'value',
			 editable: false,
			 disableKeyFilter: false,
			 hidden:true
		 }]
	 },{
		 xtype: 'fieldset',
		 collapsed: false,
		 itemId: 'leavingReasonsFieldset',
		 layout: 'vbox',
		 defaults:{
			 width:'100%'
		 },
		 style:{
			'padding-left': '0px !important;',
			'margin-top': '0px !important;',
			'margin-bottom': '0px !important;',
			'padding-top': '0px !important;',
			'padding-bottom': '0px !important;',
			'border-bottom': '0px !important;'
		 },
		 items: []
	 },{
		 xtype: 'fieldcontainer',
		 itemId: 'leavingReasonSingleFieldset',
		 layout: {
			 type: 'vbox'
		 },
		 defaults: {
			 width: 536,
			 labelAlign: 'top'
		 },
		 items: [{
			 xtype: 'textareafield',
			 fieldLabel: getServiceRequestTranslation('REQUEST_REASON'),
			 name: 'remarks',
			 itemId: 'RequestReason',
			 allowBlank: false,
			 enforceMaxLength : true,
             maxLength : 1000,
			 //vtype : 'NospaceAsInput',
			 maxLengthText : getServiceRequestTranslation('MAX_LENGTH_VALIDATION')
		 }, {
        
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'remarkSubmitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true,
            hidden:true
        }]
	 }]
    }]
});