/**
 * @author pritam.patil
 * This is used to show pop up of  complaint follow up details on click of follow up button 
 */
Ext.define('Academia.view.servicerequest.complaintrequest.ComplaintFollowUpPopUp', {
    extend: 'Ext.window.Window',
    alias: 'widget.complaintfollowuppopup',
    defaults: {
        width: 462
    },
    modal: true,
    autoScroll: true,
    frame: true,
    title: getServiceRequestTranslation('FOLLOW_UP_DETAILS'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'complaintFollowUpDetailsForm',
        items: [{
        	xtype:'hidden',
        	itemId:'isAutoApprove',
        	name:'whetherAutoApprove',
        	value:false
        },{
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            xtype: 'displayfield',
            itemId: 'user',
            fieldLabel: getServiceRequestTranslation('USER_ID'),
            name: 'user'           
        }]},{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [ {
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('PLANNED_FOLLOW_UP_DATE'),
                name: 'plannedFollowupDate',
                itemId: 'plannedFollowupDate',
                allowBlank: false,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
              //--submitFormat: CONSTANTS.DATE_FORMAT,
               // minValue: new Date(),
                disabled: true
            }, {
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('ACTUAL_FOLLOW_UP_DATE'),
                name: 'actualFollowupDate',
                allowBlank: false,
                itemId: 'actualFollowupDate',
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                value: new Date(),
                vtype: 'daterange',
                endDateField: 'nextFollowUpDate',
                disabled: true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
            }]}, {
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('FOLLOW_UP_STATUS'),
                name: 'requestStatusId',
                width: 256,
                itemId: 'complaintFollowUpStatus',
                store: 'servicerequest.servicerequestsettings.ComplaintStatusStore',
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                editable: false
            },{
                xtype: 'textareafield',
                name: 'remarks',
                width: 450,
                maxLength : 255,
                enforceMaxLength : true,
                fieldLabel: getServiceRequestTranslation('FOLLOW_UP_REMARKS'),
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            fieldLabel : getServiceRequestTranslation('SCHEDULE_NEXT_FOLLOW_UP'),
            labelWidth : 200,
            width: '100%',
            itemId: 'radioButtonsrPanel',
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'radiogroup',
                itemId: 'isApprovalRadio',
                allowBlank: false,
                items: [{
                    boxLabel:getServiceRequestTranslation('YES'),
                    name: 'isSendForApproval',
                    inputValue: false
                }, {
                    boxLabel:getServiceRequestTranslation('NO'), 
                    name: 'isSendForApproval',
                    inputValue:true,
                    checked: true
                }]
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            
            itemId: 'schedulePanel',
            hidden: true,
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('NEXT_FOLLOW_UP_DATE'),
                name: 'nextFollowupDate',
               // allowBlank: false,
                itemId: 'nextFollowUpDate',
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                minValue: new Date()               
            }, {
                xtype: 'livesearchcombo',
                fieldLabel: getServiceRequestTranslation('SELECT_NEW_ASSIGNEE'),
                name: 'assignee',
               // allowBlank: false
            }]
        },  {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getServiceRequestTranslation('SUBMIT'),
                itemId: 'complaintFollowUpDetailsSubmitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE              
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'followUpDetailsCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});