
Ext.define('Academia.view.servicerequest.documents.ServiceRequestFollowUpDocumentsGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.servicerequestfollowupdocumentsgrid',
	title:getServiceRequestTranslation('FOLLOWUP_DOCUMENTS'),
	border:true,
	columns:[{
		header:getServiceRequestTranslation('DOCUMENT_NAME'),
		dataIndex:'name',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return '<a href=#>'+value+'<a>';
			}                        
		}
	},{
		header:getServiceRequestTranslation('FOLLOWUP_UPLOADED_BY'),
		dataIndex:'createdBy',
		flex:1
	},{
		header: getCommonTranslation('UPLOADED_ON'),
		dataIndex:'submissionDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}],
	initComponent: function() {
	    var this$ = this;
	    var store = this$.buildStore();
	    Ext.apply(this$, {
	        store: store
	    });
	
	    this$.callParent(arguments);
	},
	buildStore: function() {
	    return Ext.create('Academia.store.servicerequest.common.ServiceRequestFollowUpDocumentsStore');
	}
});



