/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.servicerequest.eventcalendar.EventCalendarGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.eventcalendargrid',
	store : 'servicerequest.eventcalendar.EventCalendarGridStr',
	title: getServiceRequestTranslation('CALENDAR_LIST'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	 headerFix:{
			headerFix: true,
			portalIdsWithStructure: {
				'eventcalendarstructure':1
			}
		},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'servicerequest.eventcalendar.EventCalendarGridStr',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getHostelTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'viewCalendar',
//		cls: 'CustomToolbarBtnReject',
		text: getServiceRequestTranslation('VIEW_CALENDAR'),
//		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getServiceRequestTranslation('CALENDAR_NAME'),
		dataIndex : 'name',
		flex:1
	},{
		header : getServiceRequestTranslation('VALID_FROM'),
		dataIndex : 'validFrom',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getServiceRequestTranslation('VALID_TO'),
		dataIndex : 'validTo',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getServiceRequestTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	},{
		header : getServiceRequestTranslation('NO_OF_EVENTS'),
		dataIndex : 'noOfEvents',
		flex:1,
		renderer: function (value) {
			if (!isNullOrEmpty(value) && value > 0) {
			    return '<a href="#">'+value+'</a>';
				}
		}
	}]
});