/**
 * @author pritam.patil
 *  Apply For Placement Details Panel 
 */
Ext.define('Academia.view.servicerequest.leavefineapplyrelatedrequest.ApplyForPlacementDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.applyforplacementdetailspanel',

    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true
    }, {
        xtype: 'requesterdetailspanel',
        itemId: 'requesterDetails',
        margin: 0
    }, {
        xtype: 'fieldset',
        title: getServiceRequestTranslation('BASIC_DETAILS'),
        collapsed: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'displayfield',
                itemId: 'enterdBy',
                fieldLabel: getServiceRequestTranslation('ENTERED_BY'),
                name: 'enteredBy',
                itemId: 'enteredById'
            }, {
                xtype: 'displayfield',
                itemId: 'assignedTo',
                fieldLabel: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
                name: 'requestAssignedTo'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('REQUEST_BY'),
                
                name: 'requesterType',
                store: 'servicerequest.common.RequestBy',
                valueField: 'value',
                displayField: 'name',
                allowBlank: false,
                editable: false,
                querymode: 'local'

            },{
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('REQUEST_DATE'),
                name: 'requestDate',
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                itemId: 'RequestDate',
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                }
            }]},{
                xtype: 'fieldcontainer',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [ {
                xtype: 'nestedJsonCombo',
                fieldLabel: getServiceRequestTranslation('PROGRAM'),
                name: 'program',
                store: 'servicerequest.placementrequest.PlacementPrograms',
                valueField: 'programId',
                itemId: 'programId',
                displayField: 'programName',
                allowBlank: false,
                editable: false,
                queryMode: 'local'
            }, {
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('PLACEMENT_PERIOD'),
                
                name: 'placementPeriodId',
                store: 'servicerequest.placementrequest.PlacementPeriods',
                valueField: 'id',
                itemId: 'periodId',
                displayField: 'value',
                allowBlank: false,
                editable: false,
                queryMode: 'local',
                disabled: true
            }]
        }, {
            xtype: 'radiogroup',
            fieldLabel: getServiceRequestTranslation('WILLING_TO_TAKE_PART'),
            labelWidth: 256,
            itemId :'willingToTakePartRadio',
            columns: 2,
            vertical: true,
            items: [{
                boxLabel: getServiceRequestTranslation('YES'),
                name: 'isWillingForPlacement',
                inputValue: true
            }, {
                boxLabel: getServiceRequestTranslation('NO'),
                name: 'isWillingForPlacement',
                uncheckedValue: 'false',
                inputValue: false
            }]
        }, {
            xtype: 'textareafield',
            width: 300,
            maxLength : 255,
            enforceMaxLength : true,
            labelAlign: 'top',
            fieldLabel: getServiceRequestTranslation('REMARKS'),
            name: 'remarks',
            itemId: 'remarksId'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '7px'
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'placementSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        }]
    }]
});