/**
 * @author pritam.patil
 * Section Transfer request Details Panel 
 */
Ext.define('Academia.view.servicerequest.programcoursesectiontransferrequest.SectionRequestDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.sectionrequestdetailspanel',
    frame: false,
    border: false,
    autoScroll: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true
    }, {        
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top'                
        },
        items: [{
            xtype: 'requesterdetailspanel',
            itemId: 'requesterDetails',
            margin: 0
        }]        
    },{
        xtype: 'basicdetails',
        style: {
            marginBottom: '-29px',
            marginLeft: '0px'
        }
    },{
    	xtype:'fieldcontainer',
    	style :{
    		marginLeft : '10px',
    		width : '125px',
    		marginTop : '10px'
    	},
    	items:[{
            xtype: 'radiogroup',
            fieldLabel: getServiceRequestTranslation('TRANSFER_RELATED_TO'),
            itemId:'relatedTransfer',
            labelWidth:130,
            items: [{
                boxLabel: getProgramandcourseTranslation('PROGRAM_BATCH_SECTION'),
                name: 'isTransferRelatedProgram',
                inputValue: true,
                itemId: 'isProgram'              
            }, {
                boxLabel: getProgramandcourseTranslation('COURSE_SECTION'),
                name: 'isTransferRelatedProgram',
                itemId: 'isCourse',
                inputValue: false,  
                checked:true 
            }]
        }]
    },{
            xtype: 'fieldcontainer',
            style :{
        		marginLeft : '10px'
        	},
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('PROGRAM'),
                name: 'programId',
                store: 'servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer',
                valueField: 'programId',
                itemId: 'ProgramId',
                displayField: 'programName',
                allowBlank: false,
                editable: false,
                queryMode: 'local'               
            }, {
                xtype: 'textfield',
                fieldLabel: getServiceRequestTranslation('BATCH'),              
                name: 'batchData',   
                itemId: 'batchId'
            },{
                xtype: 'hidden',
                name: 'batchId',   
                itemId: 'hiddenBatchId'
            },{
                xtype: 'hidden',
                name: 'serviceRequestCourseVariant',   
                itemId: 'courseVariantId'
            },{
                xtype: 'hidden',
                name: 'periodId',   
                itemId: 'hiddenPeriodId'
            }]},{
                xtype: 'fieldcontainer',
                style :{
            		marginLeft : '10px'
            	},
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                items: [{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('COURSE'),
                name: 'courseVariantId',
                store: 'servicerequest.programcoursesectiontransfer.CourseForSectionTransfer',
                valueField: 'id',
                itemId: 'courseId',
                displayField: 'code',
                allowBlank: false,
                editable: false,
                queryMode: 'local'
            }, {
                xtype: 'textfield',
                name: 'fromSection',
                fieldLabel: getServiceRequestTranslation('FROM_SECTION'),
                itemId: 'fromSectionId',
                readOnly : true
            }, {
                xtype: 'hidden',
                name: 'fromSectionId',              
                itemId: 'hiddenFromSection'
            },{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('TO_SECTION'),
                name: 'toSectionId',
                store: 'servicerequest.programcoursesectiontransfer.ToSectionForBatch',
                valueField: 'id',
                itemId: 'toSectionId',
                displayField: 'value',
                allowBlank: false,
                editable: false,
                queryMode: 'local',
                hidden:true,
                disabled:true
            },{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('TO_SECTION'),
                name: 'toSectionId',
                store: 'servicerequest.programcoursesectiontransfer.ToParameterizedSectionForSectionTransfer',
                valueField: 'sectionId',
                itemId: 'toSectionForCourse',
                displayField: 'sectionCode',
                allowBlank: false,
                editable: false,
                queryMode: 'local'               
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            style: {
                marginLeft: '8px',
                marginTop : '25px'
            },
            items: [{
                xtype: 'button',
                itemId: 'btnSaveRequestDetails',
                text: getServiceRequestTranslation('UPLOAD_DOC'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
                ui: 'CustomBtnSubmit',
                itemId: 'withdrawButtonId',
                hidden: true,
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});