Ext.define('Academia.view.servicerequest.servicerequestsettings.AssigneeApproverEditableProgramLevelGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.assigneeapprovereditableprogramlevelgrid',
	border:true,
	cls:'clsAssigneeApproverGrid',
	store:'servicerequest.servicerequestsettings.AssigneeApproverProgramLevelGridStore',
	requires: [
	            'Ext.selection.CellModel',
	            'Ext.grid.*'
	        ],
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		deferEmptyText: false
	},
	plugins: [
		Ext.create('Ext.grid.plugin.CellEditing', {
			clicksToEdit: 1
		})
	],
	selModel: Ext.create('selection.cellmodel', {
		onEditorTab: function(ep, e) {
			return false;
		}
	}),
	columns:[{
		dataIndex:'id',
		hidden:true,
		sortable:false,
		menuDisabled: true
	},{
		header: getCommonTranslation('PROGRAM_GROUP_NAME'),
		dataIndex:'groupName',
		flex:0.2,
		sortable:false,
		menuDisabled: true
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex:'programName',
		flex:0.2,
		sortable:false,
		menuDisabled: true
	},{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'assigneeId',
        flex:0.2,
        sortable: false,
        menuDisabled: true,
        editor: {
            xtype: 'customcombobox',
            name: 'defaultAssignee',
            itemId: 'defaultAssignee',
            //store: 'eventmeetingminutes.EventMeetingMinutesParticipantStore',
            store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName'),
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            //allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            },
            listeners:{
            	render:function(combo) {
            		//combo.reset();
            		baseController = Academia.app.getController('Academia.controller.base.BaseController');
            		var academyLocationId = baseController.getCurrentAcademyLocation();
            		var store = combo.getStore();
            		store.on('beforeload', function(){
				    	store.getProxy().extraParams = {
							academyLocationIds : academyLocationId
						};
            		});
            	}
            }
        },
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						//rec.column.getEditor().store.load();
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
					}else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}	
				}
				catch(e){
					return null;
				}
			} else {
				
				if(Ext.isDefined(record.get('assigneeId')) && isNullOrEmpty(record.get('assigneeId'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else{
					var grid = view.up();
					var progGroupList =  grid.config.programGroupList;
					if(!isNullOrEmpty(progGroupList) && progGroupList.length>0){
						var recId = record.get('programId');
						var editor = rec.column.getEditor();
						var models = grid.getStore().getRange();

						var progGroup = Ext.Array.findBy(progGroupList, function(item) {
						    return item.program.id == recId;
						});

						if (progGroup) {
						    if (!isNullOrEmpty(progGroup.defaultAssignee)) {
						        var assigneeId = progGroup.defaultAssignee.id;
						        models[rowIndex].set("assigneeId", assigneeId);
						        editor.setValue(assigneeId);
						        var index = rec.column.getEditor().store.findExact('id',assigneeId);
		        				if(index !== -1){
		        					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',assigneeId)).data.valueCode;
		        				}else{
		        					rec.tdCls = 'gridInputCustomStyle';
		        					return getExaminationTranslation('CLICK_TO_ENTER');
		        				}	
						    } else {
						        rec.tdCls = 'gridInputCustomStyle';
						        return getExaminationTranslation('CLICK_TO_ENTER');
						    }
						} else {
						    // No match found → fallback
						    rec.tdCls = 'gridInputCustomStyle';
						    return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}
					
				}
			}						
		}
    },{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'defaultAssigneeAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('defaultAssignee',null);
        	return getServiceRequestTranslation('STUDENTS_ASSIGNEE');
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    },{
		header : getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
        dataIndex: 'assigneeIdAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('assigneeId',null);
        	return 'Auto';
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    },{
		header : getServiceRequestTranslation('DEFAULT_APPROVER'),
        dataIndex: 'approverId',
        flex:0.2,
        sortable: false,
        menuDisabled: true,
        editor: {
            xtype: 'customcombobox',
            name: 'defaultApprover',
            itemId: 'defaultApprover',
            store: 'servicerequest.servicerequestsettings.QuickSearchNameApprover',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            //allowBlank:false,
            forceSelection: true,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            },
            listeners:{
            	render:function(combo) {
            		//combo.reset();
            		baseController = Academia.app.getController('Academia.controller.base.BaseController');
            		var academyLocationId = baseController.getCurrentAcademyLocation();
            		var store = combo.getStore();
            		store.on('beforeload', function(){
				    	store.getProxy().extraParams = {
							academyLocationIds : academyLocationId
						};
            		});
            	}
            }
        },
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	if(!isNullOrEmpty(value) && value !== '') {
				try{
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
					}else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}	
				}
				catch(e){
					return null;
				}
			} else {
				if(Ext.isDefined(record.get('approverId')) && isNullOrEmpty(record.get('approverId'))){
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else{
					var grid = view.up();
					var progGroupList =  grid.config.programGroupList;
					if(!isNullOrEmpty(progGroupList) && progGroupList.length>0){
						var recId = record.get('programId');
						var editor = rec.column.getEditor();
						var models = grid.getStore().getRange();

						var progGroup = Ext.Array.findBy(progGroupList, function(item) {
						    return item.program.id == recId;
						});

						if (progGroup) {
						    if (!isNullOrEmpty(progGroup.defaultApprover)) {
						        var approverId = progGroup.defaultApprover.id;
						        models[rowIndex].set("approverId", approverId);
						        editor.setValue(approverId);
						        var index = rec.column.getEditor().store.findExact('id',approverId);
		        				if(index !== -1){
		        					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',approverId)).data.valueCode;
		        				}else{
		        					rec.tdCls = 'gridInputCustomStyle';
		        					return getExaminationTranslation('CLICK_TO_ENTER');
		        				}
						    } else {
						        rec.tdCls = 'gridInputCustomStyle';
						        return getExaminationTranslation('CLICK_TO_ENTER');
						    }
						} else {
						    // No match found → fallback
						    rec.tdCls = 'gridInputCustomStyle';
						    return getExaminationTranslation('CLICK_TO_ENTER');
						}
					}
					else{
						rec.tdCls = 'gridInputCustomStyle';
		                return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
			}						
		}
    },{
		header : getServiceRequestTranslation('DEFAULT_APPROVER'),
        dataIndex: 'approverIdAuto',
        renderer:function(value, rec, record, rowIndex, colIndex, store, view){
        	record.set('approverId',null);
        	return 'Auto';
        },
        flex:0.2,
        sortable: false,
        editor: null,
        menuDisabled: true,
        hidden:true
    }],
    listeners: {
        cellclick: function(gridView,htmlElement,columnIndex,dataRecord){
        	var column = gridView.getGridColumns()[columnIndex];
            if(column.dataIndex == "approverIdAuto" || column.dataIndex == "defaultAssigneeAuto"){
            	return false;
            }
        }
    }
});