Ext.define('Academia.view.servicerequest.servicerequestsettings.RequestSettingGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.requestsettinggrid',
	store:'servicerequest.servicerequestsettings.RequestSettingGridStore',
	border:true,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'requestsettingpanel': 1
		}
	},
	columns:[{
		header: getServiceRequestTranslation('REQUEST_CATEGORY'),
		dataIndex:'requestType',
		flex:0.5,
		renderer:function(data){
			if(data.value == 'Program Transfer'){
				return getServiceRequestTranslation('PROGRAM_TRANSFER');
			}else if(data.value == 'Course Transfer'){
				return getServiceRequestTranslation('COURSE_TRANSFER');
			}else if(data.value == 'Section Transfer'){
				return getServiceRequestTranslation('SECTION_TRANSFER');
			}else if(data.value == 'Withdraw From Program'){
				return getServiceRequestTranslation('WITHDRAW_FROM_PROGRAM');
			}else if(data.value == 'Withdraw From Course'){
				return getServiceRequestTranslation('WITHDRAW_FROM_COURSE');
			}
			else{
				return data.value;
			}
		}
	},{
		header: getServiceRequestTranslation('SLA'),
		flex:0.5,
		dataIndex:'sla'
	},{
		header: getServiceRequestTranslation('DOCUMENT_REQUIRED'),
		dataIndex:'documentRules',
		renderer:function(object){
			if(!isNullOrEmpty(object)) {
				if(object.length >0){
					return '<a href=#>'+ getServiceRequestTranslation('VIEW_SPECIFIED_DOCUMENTS') +'</a>';
				}				
			}
		},
		flex:0.5,
		hidden: true
	},{
		header: getServiceRequestTranslation('DEFAULT_ASSIGNEE'),
		dataIndex:'defaultAssignee',
		renderer:function(data, rec, record, rowIndex, colIndex, store, view){
			if(!isNullOrEmpty(record.data.serviceRequestCategory)) {
				if(record.data.serviceRequestCategory == 'FACULTY_REQUEST'){
					if(!isNullOrEmpty(data)) {
						return data.value;
					} else {
						return '';
					}
				}
				else {
					if(!isNullOrEmpty(record.data.requestType) && record.data.requestType.code == "HLR"){
						var hostelServiceRequestSetting = record.data.hostelServiceRequestSetting;
						if(!isNullOrEmpty(hostelServiceRequestSetting) && hostelServiceRequestSetting.length >0){
							return '<a href=#>'+ getServiceRequestTranslation('VIEW_SPECIFIED_DOCUMENTS') +'</a>';
						}
					} 
					else{
						var programGroupConfig = record.data.serviceRequestProgramGroupConfig;
						if(!isNullOrEmpty(programGroupConfig) && programGroupConfig.length >0){
							return '<a href=#>'+ getServiceRequestTranslation('VIEW_SPECIFIED_DOCUMENTS') +'</a>';
						}
					}
				}
			} else {
				return '';
			}
			//return comboRender(data,'value');			
		},
		flex:0.5
	},{
		header: getServiceRequestTranslation('DEFAULT_APPROVER'),
		dataIndex:'defaultApprover',
		renderer:function(data, rec, record, rowIndex, colIndex, store, view){
			if(!isNullOrEmpty(record.data.serviceRequestCategory)) {
				if(record.data.serviceRequestCategory == 'FACULTY_REQUEST'){
					if(!isNullOrEmpty(record.data) && record.data.isAutoApprove){
						return "Auto";					
					}
					else if(!isNullOrEmpty(data)) {
						return data.value;
					} else {
						return '';
					}
				}
				else {
					if(!isNullOrEmpty(record.data.requestType) && record.data.requestType.code == "HLR"){
						var hostelServiceRequestSetting = record.data.hostelServiceRequestSetting;
						if(!isNullOrEmpty(hostelServiceRequestSetting) && hostelServiceRequestSetting.length >0){
							return '<a href=#>'+ getServiceRequestTranslation('VIEW_SPECIFIED_DOCUMENTS') +'</a>';
						}
					} 
					else{
						var programGroupConfig = record.data.serviceRequestProgramGroupConfig;
						if(!isNullOrEmpty(programGroupConfig) && programGroupConfig.length >0){
							return '<a href=#>'+ getServiceRequestTranslation('VIEW_SPECIFIED_DOCUMENTS') +'</a>';
						}
					}
				}
			} else {
				return '';
			}
			/*if(!isNullOrEmpty(data)) {
				return data.value;
			} else {
				return '';
			}*/			 
		},
		flex:0.5
	},{
		header: getServiceRequestTranslation('FEE_PLAN_RULE_STAGE'),
		dataIndex:'feePlanRuleStage',
		renderer:function(data){
			if(!isNullOrEmpty(data)) {
				return data.value;
			} else {
				return '';
			}			 
		},
		flex:0.5,
		hidden: true
	},{
		header: getServiceRequestTranslation('BILLING_PREFERENCE'),
		dataIndex:'billingPreference',
		renderer:function(value) {
			return getServiceRequestTranslation(value);
		},
		flex:0.5,
		hidden: true
	},{
		header: getServiceRequestTranslation('REQUEST_RAISED_FROM'),
		dataIndex:'requestRaisedFromPortal',
		renderer:function(data, rec, record, rowIndex, colIndex, store, view){
			if(!isNullOrEmpty(record.data.serviceRequestCategory)) {
				if(record.data.serviceRequestCategory == 'FACULTY_REQUEST' || record.data.serviceRequestCategory == 'STUDENT_REQUEST'){
					if(!isNullOrEmpty(data) && data == 3) {
						return 'Core ERP, Student/Parent';
					}
					else if(!isNullOrEmpty(data) && data == 2) {
						return 'Core ERP, Employee';
					}
					else {
						return 'Core ERP';
					}
				}
				else {
					return 'Core ERP';
				}
			}
			else{
				return 'Core ERP';
			}
		},
		flex:0.5
	}],
	tbar:[{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH//,
		//cls: 'newGridBtns newEditBtn'
	}, {
		xtype: 'button',
		itemId: 'btnView',
		iconCls: 'view-icon'	,
		tooltip : getCommonTranslation('VIEW')//,
		//cls: 'newGridBtns newViewBtn'
	}],
	listeners: {
		cellclick: function(view, cell, cellIndex, record, row, rowIndex, e) {
			var dataIndex = view.panel.headerCt.getHeaderAtIndex(cellIndex).dataIndex;
			if (dataIndex == 'documentRules') {
				var documents = record.get('documentRules');
				if(!isNullOrEmpty(documents)) {
					if (record.get('documentRules').length > 0) {
						this.fireEvent('viewDocumentClicked', dataIndex, record);
					}		           
				}
			}
			else if(dataIndex == "defaultAssignee" || dataIndex == "defaultApprover"){

				if(!isNullOrEmpty(record.data.requestType) && record.data.requestType.code == "HLR"){
					var hostelServiceRequestSetting = record.get('hostelServiceRequestSetting');
					if(!isNullOrEmpty(hostelServiceRequestSetting)) {
						if (hostelServiceRequestSetting.length > 0) {
							this.fireEvent('viewDefaultAssigneeHostelClicked', dataIndex, record);
						}		           
					}
				}
				else{
					var serviceRequestProgramGroupConfig = record.get('serviceRequestProgramGroupConfig');
					if(!isNullOrEmpty(serviceRequestProgramGroupConfig)) {
						if (serviceRequestProgramGroupConfig.length > 0) {
							this.fireEvent('viewDefaultAssigneeClicked', dataIndex, record);
						}		           
					}
				}
			}
		}
	}
});