/**
 * @author Deepak Sharma
 *  Student Transfer Execution Details Panel 
 */
Ext.define('Academia.view.servicerequest.studentservicerequest.StudentTransferExecutionDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studenttransferexecutiondetailspanel',
    title: getServiceRequestTranslation('EXECUTION_DETAILS'),
    collapsible: true,
    plugins : "formlabelrequired",
    style :{
    	marginLeft : '16px'
    },
    frame : true,
    autoScroll: true,
        items: [{
        xtype: 'fieldcontainer',
        layout: {
        	type: 'vbox'
        },
        defaults: {
            width: 235,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'displayfield',
            itemId: 'user',
            fieldLabel:getServiceRequestTranslation('USER_NAME'),
            name: 'userId'
        },{
        	xtype: 'fieldcontainer',
        	layout: {
        		type: 'hbox'
        	},
        	width : '100%',
        	defaults: {
        		width: 235,
        		labelAlign: 'top'
        	},
        	items: [{
        		xtype: 'datefield',
        		fieldLabel: getServiceRequestTranslation('CLOSURE_DATE'),
        		name: 'executionDate',
        		//--submitFormat: CONSTANTS.DATE_FORMAT,
        		itemId: 'executionDateId',
        		allowBlank: false,
        		editable: false,
        		disabled:true,
        		listeners: {
        			render: function(field) {
        				field = dateFormatRender(field);						
						field.setValue(new Date());
        			}
        		}
        	},{
        		xtype: 'datefield',
        		fieldLabel: getServiceRequestTranslation('EFFECTIVE_TRANSFER_DATE'),
        		name: 'effectiveTransferDate',
        		//--submitFormat: CONSTANTS.DATE_FORMAT,
        		allowBlank: false,
        		itemId: 'effectiveTransferDateId',
        		listeners: {
        			render: function(field) {
        				return dateFormatRender(field);
        			},
        			render: function(field){
        				//V2D-85220
        				/*var batchEndDate = field.up('studenttransferexecutiondetailspanel').up().down('requesterdetailspanel').down('#batchEndDateItemId');
        				if(!isNullOrEmpty(batchEndDate.getValue())){
        					field.setMinValue(batchEndDate.getValue());
        				}*/
        				if(!isNullOrEmpty(new Date())){
        				//	field.setMinValue(new Date());
        					field = dateFormatRender(field);		
            				field.setValue(new Date());
        				}	
        				
        			}
        		}
        	}]
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CLOSURE_REASON'),
            name: 'closureReasonId',
            store: 'servicerequest.common.ClosureReasons',
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },
        {
        	xtype: 'fieldcontainer',
        	width : '100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		width: 235
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_STUDENT_DATA'),
        		name:'isRetainStudentData',
        		itemId:'retainStudentDataId'
        	},{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_ACADEMIC_DATA'),
        		name:'isRetainAcademicData',
        		itemId:'retainAcademicDataId',
        		disabled:true
        	}]
        },{
        	xtype: 'fieldcontainer',
        	width : '100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		width: 235
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_SERVICES_OPTED'),
        		name:'isRetainServicesOpted',
        		itemId:'retainServicesOptedId',
        		disabled:true
        	},{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_FEE_PAYMENT_DATA'),
        		name:'isRetainFeesPaymentData',
        		itemId:'retainFeePaymentDataId',
        		disabled:true
        	}]
        },{
        	xtype: 'textareafield',
			name: 'remark',
			maxLength : 255,
            enforceMaxLength : true,
			fieldLabel: getServiceRequestTranslation('CLOSURE_RREMARKS'),
			width: 235
        },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 235
			},
			items: [{
				xtype:'studenttransferexecutiondocumentgrid',
				itemId : 'studenttransferexecutiondocumentgrid',
				style:{
					marginLeft:'0px'
				}
			}]
		},{
        	xtype: 'fieldcontainer',
        	width : '100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		width: 235
        	},
        	items: [{
        		xtype: 'customcheckboxfield',
        		boxLabel:getServiceRequestTranslation('THE_FEES_OF_STUDENT_IS_SETTLED'),
        		name:'isStudentFeeSettled',
        		itemId:'feeOfStudentIsSettledId',
        		allowBlank: false,
				inputValue : true,
				uncheckedValue: false
        	},{
        		xtype: 'customcheckboxfield',
        		boxLabel:getServiceRequestTranslation('REQUIRED_DOCUMENTS_ARE_UPLOADED'),
        		name:'isRequiredDocumentUploaded',
        		itemId:'requiredDocumentAreUploadedId',
        		allowBlank: false,
				inputValue : true,
				uncheckedValue: false
        	}]
        },{
			xtype: 'displayfield',
			itemId:'displayCheckFeesAndDocMsgItemId',
			name: 'displayCheckFeesAndDocMsg',
			width : '100%',
			style: 'font: normal 12px courier',
			value: getServiceRequestTranslation('PLEASE_CHECK_THE_FEES_AND_DOCUMENT_DATA_TO_CLOSE_SERVICE_REQUEST')
		}]
          },{
              xtype: 'fieldcontainer',
              width : '100%',
              layout: {
              	type: 'hbox'
              },
              items: [
        	  {
                  xtype: 'button',
                  text: getServiceRequestTranslation('SUBMIT'),
                  ui: 'CustomBtnSubmit',
                  itemId: 'studentTransferExecutionSubmitBtn',
                  scale: CONSTANTS.BUTTONSIZE,
                  hidden:true,
                  formBind: true
        	  },{
        		  xtype: 'button',
        		  name: 'studentTransferExecutionDocument',
        		  text:getCommonTranslation('UPLOAD_DOC'),
        		  itemId: 'studentTransferExecutionDocument',
        		  ui: 'CustomBtnThird',
        		  hidden:true,
        		  scale : CONSTANTS.BUTTONSIZE
        	  }]
          }]
});