/**
 * @author pritam.patil
 * This is used for student termination form 
 */
Ext.define('Academia.view.servicerequest.terminations.TerminationForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.terminationform',
    frame: false,
    border: false,
    autoScroll: true,
    plugins: "formlabelrequired",
    items: [{
    	xtype:'hidden',			
    	name:'id'
    },{
    	xtype:'hidden',			
    	name:'version'
    },{
    	xtype:'nestedJsonCombo',
    	name:'assignee',
    	itemId : 'assigneeId',
    	hidden:true,
        width: 256
    },{
    	xtype:'nestedJsonCombo',
    	name:'serviceRequestSetting',
    	itemId:'settingId',
    	hidden:true,
        width: 256
    },{
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'requesterdetailspanel',
    		itemId: 'requesterDetails',
    		margin: 0
    	}]
    }, {
    	xtype: 'fieldset',
    	title: getServiceRequestTranslation('TERMINATION_REASON'),
    	collapsed: false,
    	cls: 'no-bottom-border-fieldset-cls',
    	style:{
    		'margin-bottom': '0px !important;',
        	'padding-bottom': '0px !important;'
    	},
    	items: [{
    		xtype: 'fieldcontainer',
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		layout: 'hbox',
    		items: [{
    			xtype: 'customcombobox',
    			fieldLabel: getServiceRequestTranslation('PROGRAM'),
    			store: 'servicerequest.programcoursesectiontransfer.FromPrograms',
    			name: 'programId',
    			valueField: 'id',
    			itemId: 'terminationProgramId',
    			displayField: 'value',
    			allowBlank: false,
    			editable: false,
    			queryMode : 'local'
    		}/*, {
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('TERMINATION_REASON'),
                store: 'servicerequest.TerminationReasons',
                name: 'terminationReasonId',
                valueField: 'id',
                itemId: 'terminationReason',
                displayField: 'value',
                allowBlank: false,
                editable: false
            }*/]
    	}]
    },{
    	xtype: 'fieldset',
    	collapsed: false,
    	itemId: 'terminationReasonsFieldset',
    	layout: 'vbox',
    	cls: 'no-bottom-border-fieldset-cls',
    	style:{
    		'margin-top': '0px !important;',
        	'padding-top': '0px !important;',
        	'padding-bottom': '0px !important;'
    	},
    	items: []
    }, {
    	xtype: 'fieldset',
    	collapsed: false,
    	style:{
    		'margin-top': '0px !important;',
        	'padding-top': '0px !important;'
    	},
    	items: [{
    		xtype: 'fieldcontainer',
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		layout: 'vbox',
    		items: [{
    			xtype: 'textareafield',
    			name: 'terminationRemark',
    			width: 536,
    			allowBlank: false,
    			fieldLabel: getServiceRequestTranslation('TERMINATION_REMARKS')
    		}, {
    			xtype: 'textareafield',
    			name: 'studentRemark',
    			width: 536,
    			maxLength : 255,
    			enforceMaxLength : true,
    			allowBlank: false,
    			fieldLabel: getServiceRequestTranslation('STUDENT_REMARKS')
    		},{
    			xtype: 'livesearchcombo',
    			width: 256,
    			labelAlign: 'top',
    			name: 'userId',
    			allowBlank: false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			fieldLabel: getServiceRequestTranslation('INITIATED_BY'),  
    			itemId: 'user_Id'
    		}]
    	}, {
    		xtype: 'fieldcontainer',
    		width: '100%',
    		items: [{
    			xtype: 'button',
    			itemId: 'terminationSubmitBtn',
    			text: getServiceRequestTranslation('UPLOAD_DOC'), //Submit
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    			formBind: true
    		}, {
    			xtype: 'button',
    			text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
    			ui: 'CustomBtnSubmit',
    			itemId: 'withdrawButtonId',
    			hidden: true,
    			scale: CONSTANTS.BUTTONSIZE
    		}]
    	}] 
    }]
});