/**
 * @author Deepak S
 */

Ext.define('Academia.view.setup.campaignmaster.CopyMappingPriorityWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.copymappingprioritywindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '45%',
	width: 920,
	title:getCommonTranslation('SELECT_BRAND_CAMPUS_AND_INTAKE_YEAR'),
	items: [{
		xtype:'form',
		plugins : "formlabelrequired",
		items:[{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'brandCampusDisplay',
				itemId:'brandCampusDisplayId',
				width : 462,
				fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
			},{
				xtype:'displayfield',
				name:'intakeYearDisplay',
				itemId:'intakeYearDisplayId',
				fieldLabel:getCommonTranslation('INTAKE_YEAR')
			}]
		},{
			xtype:'fieldcontainer',
			itemId:'brandCampusContainerId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items : [{
					xtype: 'customcombobox',
					name: 'brandCampusWin',
					itemId: 'brandCampusWinId',
					fieldLabel: getCommonTranslation("BRAND_CAMPUS"),
					valueField: 'id',
					displayField: 'value',
					store: 'user.UserAcademyLocationStore',
					minChars:3,
					queryParam:'qry',
					width : 462,
					typeAhead:false,
					//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					//enableKeyEvents  : 'true',
					hideTrigger:false,
					allowBlank:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					//triggerAction: '',
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}, {
					xtype: 'customcombobox',
					name: 'intakeYearWin',
					itemId: 'intakeYearWinId',
					fieldLabel: getCommonTranslation('INTAKE_YEAR'),
					store: Ext.create('Academia.store.common.IntakeYearStore'),
					valueField: 'id',
					displayField: 'value',
					emptyText: getCommonTranslation('SELECT'),
					editable: false,
					forceSelection: true,
					allowBlank: false
				},{
					xtype: 'button',
					itemId: 'addNewRowCampusBtn',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					tooltip: getCommonTranslation('ADD'),
					style:{
						marginTop:'24px'
					}
				  }]
				}]
		},{
			xtype:'fieldcontainer',
			//width:'100%',
			//cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}],
	// BEGIN SCROLL-SAVING WORKAROUND CODE    
    onRender : function() {
        this.callParent(arguments);
        this.body.on('scroll', this.saveScroll, this);
    },
    
    afterComponentLayout : function() {
        this.callParent(arguments);
        this.restoreScroll();
    },
    
    saveScroll : function() {
        this.savedScroll = this.body.getScroll();
    },
    
    restoreScroll : function() {
        var savedScroll = this.savedScroll || {};  // empty obj for when no scroll has occurred before this method is executed
        this.body.scrollTo('top', savedScroll.top || 0);
    }
    // END SCROLL-SAVING WORKAROUND CODE
});
