/**
 * @author Deepak S
 */

Ext.define('Academia.view.setup.campaignmaster.SetDefaultPriorityWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.setdefaultprioritywindow',
	modal : true,
	resizable:true,
	autoScroll: false,
	height: 200,
	width: '24%',
	title:getCommonTranslation('SELECT_DEFAULT_PRIORITY'),
	items: [{
		xtype:'form',
		plugins : "formlabelrequired",
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'schoolPriority',
				itemId: 'schoolPriorityId',
				store: Ext.create('Academia.store.campaignnew.SchoolPriorityStore'),
				valueField: 'id',
				displayField: 'value',
				emptyText: getCommonTranslation('SELECT_DEFAULT_PRIORITY'),
				editable: false,
				forceSelection: true,
				allowBlank: false
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'PrioritySubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'PriorityCancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});
