/**
 * @author priyanshi sharma
 */
Ext.define('Academia.view.sgappointment.sgappointment.SGFollowUpDetailsGridForSP', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sgfollowupdetailsgridforsp',
	store: 'sgappointment.sgappointment.SGFollowUpDetailsStoreForSP',
	title: getCommonTranslation('LIST_OF_FOLLOW-UP_DETAILS'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		markDirty:false
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sgappointment.sgappointment.SGFollowUpDetailsStoreForSP',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype:'displayfield',
		itemId:'appointmentField',
		fieldLabel: 'Appointment',
		cls:'appointmentFieldCls'
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	columns: [{
		header:  getCommonTranslation('FOLLOW-UP_SCHEDULE'),
		dataIndex: 'nextFollowupDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('FOLLOW-UP_DATE'),
		dataIndex: 'followUpDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:  getCommonTranslation('FOLLOW-UP_ACTIVITY_TYPE'),
		dataIndex: 'followUpActivityType',
		flex:.1,
		sortable:true,
		renderer:function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return value.value;
			}
		}
	},{
		header:  getCommonTranslation('REASON_FOR_FOLLOW-UP'),
		dataIndex: 'reasonForFollowUp',
		flex:.1,
		sortable:true,
		renderer:function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return value.value;
			}
		}
	},{
		header:  getCommonTranslation('FOLLOW-UP_ACTIVITY_STATUS'),
		dataIndex: 'followUpActivityStatus',
		flex:.1,
		sortable:true,
		renderer:function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return value.value;
			}
		}
	},{
		header:  getCommonTranslation('FOLLOW-UP_USER'),
		dataIndex: 'followUpUser',
		flex:.1,
		sortable:true,
		renderer:function(value, metadata, record) {
			if(!isNullOrEmpty(value)){
				return value.value;
			}
		}
	},{
		header:  getCommonTranslation('REMARK'),
		dataIndex: 'remark',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex:.1,
		hidden:true,
		sortable:true
	}]
});

