/**
 * @author Amit G
 */
Ext.define('Academia.view.sponsorship.SponsorshipAwardeesGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sponsorshipawardeesgrid',
	store: 'sponsorship.SponsorshipAwardeesSearchResultStore',
	title: getCommonTranslation('SPONSORSHIP_AWARDEES_LIST'),
	border: true,
	refreshStoreData:true,
	//margin:0,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sponsorship.SponsorshipAwardeesSearchResultStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('SPONSOR_Id'),
		dataIndex: 'sponsorCode',
		flex:1,
		sortable:true,
		summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}
	},{
		header:  getCommonTranslation('SPONSOR_NAME'),
		dataIndex: 'sponsorName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentPrintName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('NATIONAL_ID'),
		dataIndex: 'nationalID',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header:  getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex: 'studentFirstName',
		flex:1,
		sortable:true,
		hidden: true
	},{
		header:  getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex: 'studentMiddleName',
		flex:1,
		sortable:true,
		hidden: true
	},{
		header:  getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex: 'studentLastName',
		flex:1,
		sortable:true,
		hidden: true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('ACADENY_NAME'),
		dataIndex: 'academyLocationName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('DEPARTMENT'),
		dataIndex: 'department',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SUB_DEPARTMENT'),
		dataIndex: 'subDepartment',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex: 'totalAmount',
		flex:1,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header:  getCommonTranslation('ADJUSTMENT_AMOUNT'),
		dataIndex: 'settledAmount',
		flex:1,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	},{
		header:  getCommonTranslation('BALANCE_AMOUNT'),
		dataIndex: 'balanceAmount',
		flex:1,
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		}
	}]
});

