/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show contact person details in form  
 */
Ext.define('Academia.view.sponsorship.SponsorshipMasterSponsorContactPersonDetails', {
	extend : 'Ext.window.Window',
	alias : 'widget.contactpersondetailswindow',
	title:getCommonTranslation('CONTACT_PERSON_DETAILS'),
	autoScroll: true,
	height: "80%",
	modal : true,
	items: [{
	        xtype: 'idgeneratorformwin',
	        itemId: 'addContactform',
	        method: 'POST',
	        standardSubmit: false,
	        plugins : "formlabelrequired",  
	        autoScroll: true,
	        layout: {
	                type: 'vbox'
	            },
	        defaults: {
	                labelAlign: 'top',
	                //margin:10,
	                width: 256
	            },
	items : [{
    		xtype : 'hidden',
    		name : 'contactPersonId',
    		itemId :'AddContactId'
        },{
     	   xtype: 'hidden',
           name: 'sponserId',
           itemId : 'Outer_hidden'
       },{
        	xtype : 'hidden',
    		name : 'version'
        },{
    	    xtype: 'fieldcontainer',
    	    width: 'auto',
    	    defaults: {
    	    	labelAlign: 'top',
    	    	width: 256
    	    },
    	    layout: {
    		type: 'hbox'
    	    },
    	    items: [{
	            xtype: 'textfield',
	            name: 'contactName',
	            fieldLabel: getCommonTranslation('NAME'), //Name
	            allowBlank: false,
	            maxLength: 100,
//	            vtype:'NospaceAsInput'
	            vtype:'spaceAndSpecialCharactersAsInput'
	        },{
	            xtype: 'textfield',
	            name: 'designation',
	            fieldLabel: getCommonTranslation('DESIGNATION'), //Designation
	            allowBlank: false,
	            maxLength: 25,
//	            vtype:'NospaceAsInput'
	            vtype:'spaceAndSpecialCharactersAsInput'
	        }]
    	}, {
		xtype : 'textareafield',
		fieldLabel : getCommonTranslation('ADDRESS'),
		emptyText : getCommonTranslation('ENTER_ADDRESS'),
		name : 'addressText',
		allowBlank:false,
		width: 536,
		//vtype:'NospaceAsInput' V2D-488595
	},{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        		xtype : 'nestedJsonCombo',
        		fieldLabel : getCommonTranslation('ADDRESS_COUNTRY'),
        		hiddenName : 'country',
        		itemId : 'countryId',
        		emptyText : getCommonTranslation('ADDRESS_SELECT_COUNTRY'),
        		store:'common.CountryStore',
        		valueField : 'id',
        		displayField : 'countryName',
        		name : 'country',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
				allowBlank:false,
				queryMode: 'local'
        	}, {
        		xtype : 'nestedJsonCombo',
        		overrideSetValue:false,
        		fieldLabel : getCommonTranslation('ADDRESS_Generic_Field_1'),
        		hiddenName : 'genericField1',
        		itemId : 'genericFieldId1',
        		emptyText :  getCommonTranslation('ADDRESS_SELECT_Generic_Field_1'),
        		store:'organization.CountryRegionStore',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		triggerAction : 'all',
        		name : 'parentCountryRegion',
        		editable : false,    
        		valueNotFoundText:"",        		
				forceSelection :true,
				disabled:true,
				allowBlank:false,
				queryMode: 'local'
        	},
        	{
        		xtype : 'nestedJsonCombo',
        		overrideSetValue:false,
        		fieldLabel : getCommonTranslation('ADDRESS_CITY'),
        		hiddenName : 'city',
        		itemId : 'cityId',
        		emptyText : getCommonTranslation('ADDRESS_SELECT_CITY'),
        		store:'organization.CityByCountryRegion',
        		valueField : 'id',
        		displayField : 'value',
        		name : 'city',
        		disabled:true,
        		editable : false,
        		valueNotFoundText:"",        		        						
        		forceSelection :true,
        		allowBlank:false,
        		queryMode: 'local'
        	},]
		}, /*{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        		xtype : 'nestedJsonCombo',
        		overrideSetValue:false,
        		fieldLabel : getCommonTranslation('ADDRESS_Generic_Field_2'),
        		hiddenName : 'genericField2',
        		itemId : 'genericFieldId2',
        		emptyText : getCommonTranslation('ADDRESS_SELECT_Generic_Field_2'),
        		store:'organization.CountryRegionStore1',
        		valueField : 'id',
        		displayField : 'countryRegionName',
        		name : 'countryRegion',
        		triggerAction : 'all',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true  ,
				queryMode: 'local'
		}*/{
			xtype:'textfield',
			fieldLabel: getCommonTranslation('POSTAL_CODE'),
			itemId:'postalCodeItemId',
			name:'postalCode',
			maxLength:8,
			maskRe:/[0-9]/,
			enforceMaxLength : true
        	},





{
		xtype: 'fieldcontainer',
	    width: 'auto',
		fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
		allowBlank:false,
		layout : {
			type : 'hbox'
		},
		defaults: {
			enforceMaxLength : true,
			labelAlign: 'top',
			width: 256
			//cls:'inputInRow'
		},
		items : [ {
			xtype : 'customcombobox',
			hiddenName : 'phoneNumber1',
			emptyText : getCommonTranslation('ADDRESS_COUNTRY_CODE'),			
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			name : 'phoneCountryCode',
			itemId : 'phoneCountryCode',
			editable : false,			
			width: 108
		}, {
			xtype : 'numberfield',
			name : 'code',
			emptyText : getCommonTranslation('ADDRESS_AREA_CODE'),
			name : 'phoneAreaCode',
			width: 108,
			maxLength: 5,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false
		}, {
			xtype : 'numberfield',
			itemId : 'phoneNoField',
			name : 'phoneNo',
			emptyText : getCommonTranslation('ADDRESS_PHONE_NUMBER'),
			maxLength: 15,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        enforceMaxLength : true
		}
]
	}, {
	    	xtype: 'fieldcontainer',
		    width: 'auto',
	    	fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
		defaults: {
			enforceMaxLength : true,
			maxLength: 10,
			labelAlign: 'top',
			width: 256
		},
		layout : {
			type : 'hbox'
		},
		items : [ {
			xtype : 'customcombobox',
			name : 'cellCountryCode',
			itemId : 'cellCountryCode',
			emptyText : getCommonTranslation('ADDRESS_COUNTRY_CODE'),	
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			editable : false,
			width: 108
		}, {
			xtype : 'numberfield',
			name : 'cellNo',
			emptyText : getCommonTranslation('ADDRESS_PHONE_NUMBER'),
			minLength: 6,
			maxLength: 11,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false,
	        enforceMaxLength : true
		} ]
	}, {
		xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [ {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_PRIMARY_EMAIL'),
            		name : 'primaryeEmailId',
            		emptyText : getCommonTranslation('ADDRESS_ENTER_EMAIL'),
            		vtype: 'email',
            		allowBlank: false
            	}, {
            		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ADDRESS_SECONDARY_EMAIL'),
            		name : 'alternateEmailId',
            		emptyText : getCommonTranslation('ADDRESS_ENTER_EMAIL'),
            		vtype: 'email',
            		allowBlank: true
            	}]
	      }, {
	  		xtype: 'fieldcontainer',
		    width: 'auto',
		    defaults: {
		    	labelAlign: 'top',
		    	width: 256
		    },
		    layout: {
			type: 'hbox'
		    },
		    items: [ {
		        xtype: 'checkboxfield',
		        boxLabel: getCommonTranslation('USE_FOR_COMMUNICATION'), 
		        name: 'primaryeEmailUseForComm',
		        inputValue: true,
		        uncheckedValue: false,
		        itemId: 'primaryeEmailUseForComm'
		    },{
		        xtype: 'checkboxfield',
		        boxLabel: getCommonTranslation('USE_FOR_COMMUNICATION'), 
		        name: 'alternateEmailUseForComm',
		        inputValue: true,
		        uncheckedValue: false,
		        itemId: 'alternateEmailUseForComm'
		    }]
		      }, {
		
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    items: [{
        	xtype : 'textfield',
            		fieldLabel : getCommonTranslation('BENEFICIARY_NAME'),
            		name : 'beneficiaryName',
            		emptyText : getCommonTranslation('BENEFICIARY_NAME'),
            		allowBlank: true,
                    maxLength: 100,
                    stripCharsRe: /[^0-9a-zA-Z_ ]/g
                    
        	}, {
        		xtype : 'textfield',
            		fieldLabel : getCommonTranslation('ACCOUNT_NO'),
            		name : 'accountNo',
            		emptyText : getCommonTranslation('ACCOUNT_NO'),
            		allowBlank: true,
                     maxLength: 100,
                    stripCharsRe: /[^0-9a-zA-Z]/g
        	},
{
        		xtype : 'nestedJsonCombo',
        		
        		fieldLabel : getCommonTranslation('ACCOUNT_TYPE'),
        		itemId : 'accountTypeId',
        		emptyText :  getCommonTranslation('ACCOUNT_TYPE'),
        	    store: 'feeandpayment.receipts.AccountTypeStore',
        		valueField : 'id',
        		displayField : 'value',
        		triggerAction : 'all',
        		name : 'accountTypeId',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
			    //	queryParam:'bankName',
	    		//minChars:3,
	    			allowBlank: true,
	    			typeAhead:false,
                    editable:true,
			//	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 
        	}]
	},{
	    xtype: 'fieldcontainer',
	    width: 'auto',
	    defaults: {
	    	labelAlign: 'top',
	    	width: 256
	    },
	    layout: {
		type: 'hbox'
	    },
	    cls:'fieldContainerClsStage',
	    items: [{
        		xtype : 'nestedJsonCombo',
        		
        		fieldLabel : getCommonTranslation('BANK_NAME'),
        		itemId : 'bankId',
        		emptyText :  getCommonTranslation('BANK_NAME'),
        	    store: 'feeandpayment.receipts.BankNameStore',
        		valueField : 'id',
        		displayField : 'value',
        		triggerAction : 'all',
        		name : 'bankNameId',
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
			    	queryParam:'bankName',
	    		minChars:3,
	    			allowBlank: true,
	    			typeAhead:false,
                    editable:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				 
        }	 ,{
        		xtype : 'nestedJsonCombo',
        		overrideSetValue:false,
        		fieldLabel : getCommonTranslation('IFSC_CODE'),
        		itemId : 'ifscCode',
        		emptyText : getCommonTranslation('IFSC_CODE'),
        		store:'feeandpayment.receipts.BankIfscStore',
        		valueField : 'id',
        		displayField : 'code',
        		name : 'ifscCodeId',
        		triggerAction : 'all',
        		editable : false,
                disabled:true,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
			    	queryParam:'ifscCode',
	    		minChars:3,
	    			allowBlank: true,
	    			typeAhead:false,
                    editable:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	},
{
        		xtype : 'nestedJsonCombo',
        		overrideSetValue:false,
        		fieldLabel : getCommonTranslation('BRANCH_NAME'),
        		itemId : 'branchName',
        		emptyText : getCommonTranslation('BRANCH_NAME'),
        		store:'feeandpayment.receipts.BranchNameStore',
        		valueField : 'id',
        		displayField : 'value',
        		name : 'branchNameId',
        		triggerAction : 'all',
				disabled:true,
        		editable : false,
        		valueNotFoundText:"",        		        						
				forceSelection :true,
			    	queryParam:'branchName',
	    		minChars:3,
	    			allowBlank: true,
	    			typeAhead:false,
                    editable:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	}]
	},{
		xtype: 'fieldcontainer',
		items: [{
			xtype: 'button',
			itemId: 'btnSaveContactForm',
			text: getCommonTranslation('SAVE'), //Submit
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype: 'button',
			itemId: 'btnCancelContactForm',
			text: getCommonTranslation('CANCEL'), //Cancel
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
	}]
});
