Ext.define('Academia.view.sponsorship.SponsorshipReceiptSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.sponsorshipreceiptsearchform',
    cls:'customSearchPanel sponsorshipReceiptSearchCls',
    style:{'padding':'0px !important'},
    frame: false,
    margin:0,
    items: [{
        xtype: 'form',
        cls:'customSearchInnerPanel',
        itemId: 'sponsorshipReceipt',
        width: '100%',
        items: [ {
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
            	width: 700,
                labelAlign: 'top'
            },
            items: [{

    			xtype : 'multiselectcombofield',
    			name : 'academyLocation',
    			itemId:'academyLocationId',
    			autoloadStore: false,
    			width: 536,
    			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
    			store:'common.AcademyLocationNameSeparated',
    			valueField: 'id',
    		    displayField: 'value',
    		    maskRe : /^\S*$/,
    			allowBlank : false,
    			queryParam:'qry',
    			minChars:3,
    			typeAhead:true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					},
    					afterRender: function(combo){
    						combo.getStore().on("load", function(store, items){
    							if(items.length==0)
    								Ext.select('.x-boundlist-item').elements[0].hidden = true;
    							else
    								Ext.select('.x-boundlist-item').elements[0].hidden = false;
    				        });
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			/*	getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}*/
    			}
            
            }]

        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{

                /*xtype: 'textfield',
                fieldLabel: getCommonTranslation('STUDENT_ID'),
                name: 'STUDENT_ID',
                itemId: 'sponReceipt_studId'*/
            	
            	xtype: 'customcombobox',
    			name:'STUDENT_ID',
    			itemId:'sponReceipt_studId',
    			store: 'feeandpayment.reports.Student',
    			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'studentNameOrCode',
    			minChars:3,
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			disabled:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code / value}' +
    					'</div>';
    				}
    			}
            },{
            	xtype: 'customcombobox',
            	name: 'SPONSOR_ID',
            	itemId: 'sponMaster_sponId',
            	fieldLabel: getCommonTranslation('SPONSOR_CODE_NAME'),
            	store:'sponsorship.SponsorsNameCodeStore',
            	valueField: 'id',
            	displayField: 'value',
            	queryParam:'sponsorNameOrCode',
            	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            	enableKeyEvents  : 'true',
            	minChars:3,
            	typeAhead:false,
            	forceSelection:true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	triggerAction: '',
            	hideTrigger:false,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{sponsorshipCode} / {sponsorshipName}' +
            			'</div>';
            		}
            	}
            
            }]
        }, {
        	 xtype: 'fieldcontainer',
             layout: 'hbox',
             defaults: {
             	width: 256,
                 labelAlign: 'top'
             },
        	items: [/*{

                xtype: 'textfield',
                fieldLabel: getCommonTranslation('STUDENT_NAME'),
                name: 'STUDENT_NAME',
                itemId: 'sponReceipt_studName'
            },*/ {
            	xtype: 'customcombobox',
				name: 'transactionType',
                itemId: 'cmbTransactionType',
                fieldLabel: getCommonTranslation('TRANSACTION_TYPE'),
                store : 'scholarships.TransactionTypes',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                hidden:true,
                //queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true
            }]
        },{
          	 xtype: 'fieldcontainer',
             layout: 'hbox',
             defaults: {
             	width: 256,
                 labelAlign: 'top'
             },
        	items: [{
        		xtype:'displayfield',
        		value:'<b class="menu-title">'+getCommonTranslation('TRANSACTION_DATE')+'</b>',
        		style: {
        			textDecoration: "underline"
        		}
        	}]
        }, {
        	 xtype: 'fieldcontainer',
             layout: 'hbox',
             defaults: {
             	width: 256,
                 labelAlign: 'top'
             },
        	items: [{
                xtype: 'datefield',
                fieldLabel: getCommonTranslation('FROM_DATE'),
                name: 'TRANSACTION_DATE_FROM',
                itemId: 'fromDate',
              //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
            	listeners: {
            		render: function(field) {
            			return dateFormatRender(field);
            		}
            	},
    			endDateField :'toDate',
    			vtype: 'daterange',
                //maxValue: new Date()
            }, {
            	 xtype: 'datefield',
                 fieldLabel: getCommonTranslation('TO_DATE'), 
                 name: 'TRANSACTION_DATE_TO',
                 itemId: 'toDate',
               //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
             	 listeners: {
             		 render: function(field) {
             			 return dateFormatRender(field);
             		 }
             	 },
    			 startDateField : 'fromDate',
    			 vtype: 'daterange',
            }]
        }, {
        	xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls CustomSearchPanelBtnLeftMargin',
    		layout : {
    			type : 'hbox'
    		},
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'sponsorshipReceiptSearchBtn',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				margin: '0 16 0 0'
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			} ]
		}]
    }]


});