/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show transaction details in grid
 */
Ext.define('Academia.view.sponsorship.SponsorshipReceiptsTransactionsDetailsGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.transactionsdetailsgrid',
	store : 'sponsorship.SponsorshipTransactionDetailsStore',
	title :getCommonTranslation('TRANSACTIONS_DETAILS'),//Transactions Details
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	columns :[{
		header :getFeeAndPaymentCommonTranslation('BILL_NO'),//Instrument No
		dataIndex : 'billNo',
		flex:.2,
		summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}
	},{
		header :getFeeAndPaymentCommonTranslation('BILLING_DATE'),//Instrument Date
		dataIndex : 'billingDate',
		flex:.2,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header :getFeeAndPaymentCommonTranslation('BILLED_AMOUNT'),//Instrument Drawn On
		dataIndex : 'billedAmount',
		flex:.2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,store.data.items[0].get("billCurrencyId"));
			}
		}
		},{
		header :getFeeAndPaymentCommonTranslation('AMOUNT_SETTELLED'),//Voucher Reference No
		dataIndex : 'amountAdjusted',
		flex:.2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,store.data.items[0].get("billCurrencyId"));
			}
		}
	},{
		header :getFeeAndPaymentCommonTranslation('BALANCE_AMOUNT'),//Voucher Reference No
		dataIndex : 'balanceAmount',
		flex:.2,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("billCurrencyId"));
			}
		},
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,store.data.items[0].get("billCurrencyId"));
			}
		}
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'alExchangeRate',
		flex : .3,
		hidden:true
	},{
		header : getFeeAndPaymentCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'balanceAmountInALBaseCurrency',
		flex : .3,
		hidden:true,
		itemId:'balanceAmountInALBaseCurrency',
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("acadLocConvertedCurrencyId"));
			}                    
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(!isNullOrEmpty(value)){
				 return Ext.util.Format.currency(value,'',record.get("acadLocConvertedCurrencyId"),false);	
			}
			
		}
	}],    
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'sponsorship.SponsorshipTransactionDetailsStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}]
});