
Ext.define('Academia.view.standardMaster.StdMasterParentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.stdMasterParentGrid',
	title: getCommonTranslation('STD_MASTER_GRID'),
	itemId: 'stdMasterParentGrid',
	//layout: 'fit',
	columns: [],
	refreshStoreData:true,
	columnLines: true,
	border:true,
	hidden: true,
	isFixHeightGrid: true,
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'standardMaster':1
		}
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
//		emptyText: getCommonTranslation('SELECT_RECORD_TO_SHOW_DATASET'),
		deferEmptyText: false
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'	
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
        xtype: 'checkboxfield',
        itemId: 'useAsDropdownCheckbox',
        style: 'margin-top: 25px',
        labelAlign: 'right',
        boxLabel: getCommonTranslation('USE_AS_DROPDOWN_ON_PERSONAL_INFORMATION'),
        name: 'useAsDropdownCheckbox',
        inputValue : false,
        hidden : true
    }],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: this.store,
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}]

});
