/**
 * @author Rohit Thadani
 */
Ext.define('Academia.view.student.currentEnrollmentReport.StudentCurrentReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentcurrentreportgrid',
	store: 'student.studentenrollmentreport.StudentCurrentReportStore',
	title: getCommonTranslation('CURRENT_STUDENTS'),
	border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		emptyText :getCommonTranslation('EMPTY_MESSAGE'),
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [/*{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			//store : 'student.report.StdDemographicReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}*/]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
	},{
		header:  getCommonTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		flex:.1
	},{
		header:  getCommonTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		flex:.1
	},{
		header:  getCommonTranslation('ADMISSION_DATE'),
		dataIndex: 'admissionDate',
		renderer:function(value, meta, record){
			return dateRender(value);
		},
		flex:.1
	}]
});
