Ext.define('Academia.view.student.disciplinaryActionSUReport.StudentDisciplinaryActionsSUReportGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentdisciplinaryactionssureportgrid',
	title: getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU'),
	border: true,
	frame:false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		header:  getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1
	},{
		header:  getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		hidden:true
	},{
		header:  getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		hidden:true
	},{
		header: getPersonModuleTranslation('TYPE_OF_MISCONDUCT'),
		dataIndex: 'misconductType',
		sortable: true,
		flex: .2
	},  {
		header: getPersonModuleTranslation('DATE_OF_MISCONDUCT'),
		dataIndex: 'dateOfMisconduct',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getPersonModuleTranslation('TEMPORARY_SUSPENSION'),
		dataIndex: 'tempSuspension',
		sortable: true,
		flex: .2,
		renderer:function(value, meta, record) {
			var val = '';
			if(record.data.tempSuspension == true) {
				val = 'Yes';
			}else {
				val = 'No'; 
			}		
			return val;
		}
	}, {
		header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_DATE'),
		dataIndex: 'tempSuspensionDate',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getPersonModuleTranslation('DISCIPLINARY_COMMITTEE'),
		dataIndex: 'disciplinaryCommittee',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_ACCESS_RESTRICTION'),
		dataIndex: 'temporaryAccessRestriction',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_LAPSE'),
		itemId: 'isTempSuspensionLapse',
		dataIndex: 'isTempSuspensionLapse',
		hidden:true,
		sortable: true,
		flex: .2,
		renderer:function(value, meta, record) {
			var val = '';
			if(record.data.isTempSuspensionLapse == true) {
				val = 'Yes';
			}else {
				val = 'No'; 
			}		
			return val;
		}
	},{
		header: getPersonModuleTranslation('TEMPORARY_SUSPENSION_LAPSE_DATE'),
		dataIndex: 'tempSuspensionLapseDate',
		itemId: 'tempSuspensionLapseDate',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header:  getPersonModuleTranslation('DISCIPLINARY_DETERMINATION'),
		dataIndex: 'disciplinaryDetermination',
		hidden:true,
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			return value; 
		}
	}, {
		header: getPersonModuleTranslation('DISCIPLINARY_DETERMINATION_DATE'),
		dataIndex: 'determinationDate',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value); 
			}                        
		}
	}, {
		header: getPersonModuleTranslation('DISCIPLINARY_COMMITTEE_HEARING_DATE'),
		dataIndex: 'determinationHearingDate',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value); 
			}                        
		}
	}, {
		header: getPersonModuleTranslation('IS_GUILTY'),
		dataIndex: 'isGuilty',
		sortable: true,
		flex: .2,
		renderer:function(value, meta, record) {
			var isGuilty=value;
			var val = '';
			if(isGuilty == true) {
				val = 'Yes';
			}else {
				val = 'No'; 
			}		
			return val;
		}
	}, {
		header: getPersonModuleTranslation('APPEAL'),
		dataIndex: 'appeal',
		sortable: true,
		flex: .2,
		renderer:function(value, meta, record) {
			var val = '';   
			if(value == true) {
				val = 'Yes';
			}else {
				val = 'No'; 
			}		
			return val;
		}
	}, {
		header: getPersonModuleTranslation('APPEAL_DATE'),
		dataIndex: 'appealDate',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		}
	}, {
		header: getPersonModuleTranslation('APPEAL_OUTCOME'),
		dataIndex: 'appealOutcome',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.raw.appealOutCome)){
				return record.raw.appealOutCome; 
			}
			else{
				return "";
			}
		}
	}, {
		header: getPersonModuleTranslation('DETAILS_OF_MISCONDUCT'),
		dataIndex: 'misconductDetail',
		sortable: true,
		flex: .2
	}, {
		header: getPersonModuleTranslation('NOTES'),
		dataIndex: 'notes',
		sortable: true,
		hidden:true,
		flex: .2
	},{
		header: getPersonModuleTranslation('SANCTION_DETAILS'),
		dataIndex: 'sanctionDetails',
		sortable: true,
		flex: .2,
		renderer: function(value, metadata, record) {
			return '<a href="#">' + "View" + '</a>';
		}
	},{
		header:  getPersonModuleTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		sortable:true,
		hidden:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(record.data.documents.length>0) {					
					return '<a href="#">' + "View" + '</a>';
				} 
			}                        
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.report.StudentDisciplinaryActionSUReportStore');
	}
});