/**
 *  This form is used for student and StudentExaminersReportForm action
 *  @author Amit G
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentExaminersReportForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentexaminersreportform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'studentExaminersReporthidden',
        name: 'id'
    },{

        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('EXAMINER_ID'),
            itemId: 'functionaryItemId',
            name: 'functionaryID', 
            store:'common.AllUserBySmartSearchFPR',
            allowBlank: false,
            forceSelection: true,
			 queryParam:'codeOrName',
	            triggerAction: 'all',
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            enableKeyEvents  : 'true',
	            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				minChars:3,
				displayField: 'value', 
				valueField: 'id',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
	        },{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('EXAMINERS_REPORT_NAME'),            
            itemId: 'nameItemId',
            name: 'name',
            maxLength:100,
            readOnly:true,
            allowBlank: false
        }]
    
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('EXAMINERS_REPORT_LAST_NAME'),            
            itemId: 'lastNameItemId',
            name: 'lastName',
            readOnly:true,
            maxLength:100
        },{
        	xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('EXAMINER_TYPE'),
            itemId: 'functionaryTypeItemId',
            name: 'functionaryType', 
            store: 'common.ExaminerTypeStore',
            allowBlank: false,
            forceSelection: true,
			displayField: 'value',
			valueField: 'id',
			editable: false,
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('AUDIT_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'auditDate',
            name: 'auditDate',
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
              },
            allowBlank: false,
            vtype : 'daterange',
            readOnly:true
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('AUDIT_ID'),
            itemId: 'auditId',
            name: 'auditId',
            allowBlank: false,
            readOnly:true
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentexaminersreportdocumentgrid',
			itemId:'studentexaminersreportdocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },
        {
			 xtype: 'button',
			 //width: 536,
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadStudentExaminersReportItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
