/**
 *  This form is used for student and faculty disciplinary action
 *  @author Sachin.Bangar
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentJointDegreeForm', {
    extend: 'Academia.view.common.IdGeneratorForm',
    alias: 'widget.studentjointdegreeform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'student_joint_degree_hidden_field',
        name: 'id'
    },{

        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('COLLABORATION_AGREEMENT_TYPE'),
            itemId: 'collaborationAgreementType',
            name: 'collaborationAgreementType', 
            store:'common.CollaborationAgreementTypeStore',
            allowBlank: false,
            forceSelection: true,
			displayField: 'name',
			valueField: 'value',
			editable: false
        },{
	       	 xtype: 'nestedJsonCombo',
	    	 fieldLabel: getCommonTranslation('PARTNER_INSTITUTION_1'),
	    	 store: Ext.create('Academia.store.personinfo.common.personalinfo.PartnerInstitutionStore'),
	    	 itemId: 'partnerInstitution1',
	    	 valueField: 'id',
	    	 allowBlank: false,
	    	 displayField: 'value',
	    	 name: 'partnerInstitution1',
	    	 forceSelection:true,
	    	 autoload: true,
	    	 queryParam:'codeOrValue',
	    	 minChars:3,
	    	 typeAhead:false,
	    	 hideTrigger:false,
	    	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    	 listConfig: {
	    		 listeners: {
	    			 beforeshow: function(picker) {
	    				 picker.minWidth = picker.up('combobox').getSize().width;
	    			 }
	    		 },
	    		 loadingText: getCommonTranslation('SEARCHING'),
	    		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    		 getInnerTpl: function() {
	    			 return '<div class="search-item">' +
	    			 '{code}'  +
	    			 '</div>';
	    		 }
	    	 }
        },{
			xtype: 'nestedJsonCombo',
			fieldLabel: getCommonTranslation('PARTNER_INSTITUTION_COUNTRY_1'),
			store: 'common.CountryStore',
			itemId: 'partnerInstitutionCountry1',
			name: 'partnerInstitutionCountry1',
			valueField: 'id',
			displayField: 'countryName',
			editable: false,
			allowBlank: false,
	        forceSelection: true
		},{
	       	 xtype: 'nestedJsonCombo',
	    	 fieldLabel: getCommonTranslation('PARTNER_INSTITUTION_2'),
	    	 store: Ext.create('Academia.store.personinfo.common.personalinfo.PartnerInstitutionStore'),
	    	 itemId: 'partnerInstitution2',
	    	 valueField: 'id',
	    	 allowBlank: true,
	    	 displayField: 'value',
	    	 name: 'partnerInstitution2',
	    	 forceSelection:true,
	    	 autoload: true,
	    	 queryParam:'codeOrValue',
	    	 minChars:3,
	    	 typeAhead:false,
	    	 hideTrigger:false,
	    	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    	 listConfig: {
	    		 listeners: {
	    			 beforeshow: function(picker) {
	    				 picker.minWidth = picker.up('combobox').getSize().width;
	    			 }
	    		 },
	    		 loadingText: getCommonTranslation('SEARCHING'),
	    		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    		 getInnerTpl: function() {
	    			 return '<div class="search-item">' +
	    			 '{code}'  +
	    			 '</div>';
	    		 }
	    	 }
        }]
    
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
			xtype: 'nestedJsonCombo',
			fieldLabel: getCommonTranslation('PARTNER_INSTITUTION_COUNTRY_2'),
			store: 'common.CountryStore',
			itemId: 'partnerInstitutionCountry2',
			name: 'partnerInstitutionCountry2',
			valueField: 'id',
			displayField: 'countryName',
			editable: false,
			allowBlank: true,
	        forceSelection:false
		},{
            xtype: 'numberfield',
            fieldLabel: getCommonTranslation('FEES_EXEMPTED_PER_YEAR'),            
            itemId: 'feesExemptedPerYear',
            name: 'feesExemptedPerYear',
            maxLength:10,
            allowBlank: true,
            minValue : 0,
            decimalPrecision : 2,
            hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false
            
        },{
			 xtype      : 'radiogroup',
			 fieldLabel : getCommonTranslation('IFR_REDUCED'),
			 itemId: 'ifrReduced',
			 name: 'ifrReduced',
			 defaults: {
				 flex: 1
			 },
			 layout: 'hbox',
			 items:[{ 
				 boxLabel: getCommonTranslation('YES'), 
				 name: 'ifrReduced', 
				 inputValue: true
			 },{ 
				 boxLabel: getCommonTranslation('NO'), 
				 name: 'ifrReduced', 
				 inputValue: false,
				 checked:true
			 }]
		 }]
    }, {

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 530
        },
        items: [{
            xtype: 'textareafield',
            fieldLabel: getCommonTranslation('CERTIFICATE_TEXT'),            
            itemId: 'certificate',
            name: 'certificate',
            maxLength:1000,
           // width: 536,   
            labelAlign: 'top',
            allowBlank: false
        },{ 
			xtype: 'textareafield',
			name: 'feesExemptedPerYearReason',
			itemId : 'feesExemptedPerYearReason',
			fieldLabel: getCommonTranslation('FEES_EXEMPTED_PER_YEAR_REASON'), //Approval Remarks
			labelAlign: 'top',
			//width: 536,                
			maxLength:255
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{ 
			xtype: 'textareafield',
			name: 'ifrReducedReason',
			itemId : 'ifrReducedReason',
			fieldLabel: getCommonTranslation('IFR_REDUCED_REASONS'), //Approval Remarks
			labelAlign: 'top',
			width: 530,                
			maxLength:255
		},{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('AUDIT_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'auditDate',
            name: 'auditDate',
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
              },
            allowBlank: false,
            vtype : 'daterange',
            readOnly:true
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('AUDIT_ID'),
            itemId: 'auditId',
            name: 'auditId',
            allowBlank: false,
            readOnly:true
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentjointdegreedocumentgrid',
			itemId:'studentjointdegreedocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},
	{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		defaults : {
			width : 260,
			labelAlign : 'top'
		},
		items: [{ 
	            xtype: 'textfield',
	            fieldLabel: getCommonTranslation('PARTNER_NUMHUS'),
	            itemId: 'partnerNumhusId',
	            name: 'partnerNumhus',
	            maxLength: 50,
	            hidden: true
		},{ 
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('PARTNER_UKPRN'),
            itemId: 'partnerUkprnId',
            name: 'partnerUkprn',
            maxLength: 50,
            hidden: true
		},{ 
	        xtype: 'textfield',
	        fieldLabel: getCommonTranslation('PARTNER_SID'),
	        itemId: 'partnerSidId',
	        name: 'partnerSid',
	        maxLength: 17,
	        hidden: true
	}]
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE
        },
        {
			 xtype: 'button',
			 //width: 536,
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadStudentJointDegreeItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
