/**
 *  This form is used for student and StudentThesisUploadForm action
 *  @author Amit G
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentThesisUploadForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentthesisuploadform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'studentThesisUploadhidden',
        name: 'id'
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{ 
			xtype: 'textareafield',
			name: 'details',
			itemId : 'thesisDetialsItemId',
			fieldLabel: getCommonTranslation('DETAILS'),
			labelAlign: 'top',
			allowBlank: false,
			width: 525,                
			maxLength:255
		}]
    
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('AUDIT_DATE'),
            itemId: 'auditDate',
            name: 'auditDate',
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
              },
            allowBlank: false,
            vtype : 'daterange',
            readOnly:true
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('AUDIT_ID'),
            itemId: 'auditId',
            name: 'auditId',
            allowBlank: false,
            readOnly:true
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width: 536,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentthesisuploaddocumentgrid',
			itemId:'studentThesisUploadDocumentGridItemId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },
        {
			 xtype: 'button',
			 //width: 536,
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadStudentThesisItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
