/**
 * 
 * @author Amit G
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentThesisUploadGrid', {
	alias: 'widget.studentthesisuploadgrid',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    title: getCommonTranslation('STUDENT_THESIS_UPLOAD'),
    border: true,
    
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode: true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        disabled:true,
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode: true
    },{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        disabled:true,
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    },{
    	xtype:'button',
    	itemId:'sendDocument',
    	scale: CONSTANTS.BUTTONSIZE,
    	text:getExaminationTranslation('SEND_DOCUMENT')
    },{
    	xtype: 'multiselectcombofield',
    	name:'userExamPanel',
		store:'student.postGraduateManagement.UserExamPanelListStore',
		itemId:'userExamPanel',
		width:500,
		cls: 'userExamPanelCls',
		//minHeight:30,
		displayField: 'valueCode',
        valueField: 'id',
		forceSelection : true,
		hideTrigger:false,
		emptyText:getPersonModuleTranslation('NOMINATE_EXAMINERS')
    }],
    columns : [ {
		        header: getCommonTranslation('DETAILS'),
		        dataIndex: 'details',
		        ItemId: 'studentThesisUploadItemId',
		        sortable: true,
		        hidden:false,
		        flex: 1 
			    },{
    			header : getPersonModuleTranslation('DOCUMENT'),
    			dataIndex: 'studentThesisUploadDocuments',
    			flex:1,
    			sortable:true,
    			renderer:function(value, meta, record){
    				console.log('record='+record)
    				if(!isNullOrEmpty(value)) {
    					if(record.data.studentThesisUploadDocuments.length>1) {					
    						return '<a href=#>'+record.data.studentThesisUploadDocuments.length+'<a>';
    					} else if(record.data.studentThesisUploadDocuments.length==1) {
    						return '<a href=#>'+record.data.studentThesisUploadDocuments[0].name+'<a>';
    					} 
    				}                        
    			}
    		},{
    	        header: getCommonTranslation('AUDIT_DATE'),
    	        dataIndex: 'auditDate',
    	        ItemId: 'auditDateItem',
    	        sortable: true,
    	        hidden:true,
    	        flex: 1 ,
    	        renderer : function(value){
    	       		return  dateRender(value);   	
    	        }
    	    },{
    	    	header: getCommonTranslation('AUDIT_ID'),
    			dataIndex: 'auditId',
    			ItemId: 'auditIdItem',
    			flex: 1,
    			sortable: true,
    			hidden:true,
    			renderer:function(value, meta, record){
    				if(!isNullOrEmpty(value)) {
    					return record.data.auditId.code;
    				}                        
    			}
    		},{
    	    	header: getExaminationTranslation('FILE_SIZE'),
    			dataIndex: 'documentSize',
    			flex: 1,
    			sortable: true,
    			renderer:function(val){
    				if(val){
    					return val+' MB';
    				}else{
    					return '';
    				}
    				
    				
    			}
    		}],
    		initComponent: function() {
    	        var this$ = this;
    	        var store = this$.buildStore();
    	        Ext.apply(this$, {
    	            store: store,
    	            dockedItems: [{
    	                xtype: 'toolbar',
    	                dock: 'bottom',
    	                items: [{
    	                    xtype: 'custompagingtoolbar',
    	                    plugins: ['pagesize'],
    	                    store: store,
    	                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    	                    displayInfo: true
    	                }]
    	            }]
    	        });
    	        this$.addExportToolBarItems(this$);
    	        this$.callParent(arguments);
    	    },
    		buildStore: function() {
    			return Ext.create('Academia.store.student.postGraduateManagement.StudentThesisUploadGridStore');
    		}
});