/**
 * @author Amit G
 */
Ext.define('Academia.view.student.studentDeletedReport.StudentDeletedReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentdeletedreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'customSearchPanel',
	plugins:"formlabelrequired",
	/*style: 'margin: 0 16px !important',
	items:[{
		xtype:'form',
		cls:'customSearchPanel',*/
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
	     		xtype: 'customcombobox',
	     		name:'studentId',
	     		itemId:'studentId',
	     		store: 'student.report.DeletedStudentNameStore',
	     		fieldLabel : getCommonTranslation('ARCHIVED_STUDENT_ID_CODE_NAME'),
	     		valueField: 'id',
	 			displayField: 'value',
	 			queryParam:'codeOrName',
	     		minChars:3,
	     		typeAhead:false,
	     		width: 536,
	     		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	     		enableKeyEvents  : 'true',
	     		hideTrigger:false,
	     		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	     		triggerAction: '',
	     		forceSelection:true,
	     		listConfig: {
	     			listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	     			loadingText: getCommonTranslation('SEARCHING'),
	     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	     			getInnerTpl: function() {
	     				return '<div class="search-item">' +
	     				'{value} / {code}' +
							'</div>';
	     			}
	     		}
	     	},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYear',
				itemId : 'intakeYear',
				displayField:'value',
				valueField:'id',
				width: 256,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.student.report.DeletedStudentFiltersCommonStore');
						combo.bindStore(store)
					}
				}
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
					name : 'academicTerm',
					itemId : 'academicTerm',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					hidden : false,
					listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.student.report.DeletedStudentFiltersCommonStore');
							combo.bindStore(store)
						}
					}
				},{
					xtype : 'customcombobox',
					name : 'programGroupCombo',
					itemId: 'programGroupCombo',
					fieldLabel : getCommonTranslation('PROGRAM_GROUP'),
					valueField: 'id',
		            displayField: 'value',
		            queryParam:'codeOrName',
		            minChars:3,
		            typeAhead:false,
	                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                forceSelection:true,
	                listeners: {
						render: function(combo) {
	                    	  var store = Ext.create('Academia.store.student.report.DeletedStudentFiltersCommonStore');
	                         combo.bindStore(store);
	                     }
					},listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}'  +
							'</div>';
						}
					}
				},{
	            	 xtype: 'customcombobox',
		    			name:'PROGRAM_NAME',
		    			itemId:'programId',
		    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    			valueField: 'id',
		    			displayField: 'valueCode',
		    			queryParam:'codeOrName',
		    			minChars:3,
		    			allowBlank: true,
		    			typeAhead:false,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                forceSelection:true,
		                listeners: {
    						render: function(combo) {
		                    	  var store = Ext.create('Academia.store.student.report.DeletedStudentFiltersCommonStore');
		                         combo.bindStore(store);
		                     }
    					},listConfig: {
    						listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    						loadingText: getCommonTranslation('SEARCHING'),
    						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    						getInnerTpl: function() {
    							return '<div class="search-item">' +
    							'{code} / {value}'+
    							'</div>';
    						}
    					},
		    		
		            }]
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width: 256
				},
				items:[{
	                 xtype: 'customcombobox',
	                 name: 'BATCH_NAME',
	                 itemId: 'batchId',
	                 fieldLabel: getPersonModuleTranslation('BATCH'),
	                 disabled:true,
	                 editable: false,
	                 queryMode: 'local',
	                 displayField: 'value',
	                 valueField: 'id',
	                 listeners: {
	                     render: function(combo) {
	                    	 var store = Ext.create('Academia.store.student.report.DeletedStudentFiltersCommonStore');
	                         combo.bindStore(store);
	                     }
	                 }
	             },{
	                 xtype: 'customcombobox',
	                 itemId:'periodId',
	                 disabled:true,
	                 editable: false,
	                 displayField: 'value',
	                 valueField: 'id',
	                 queryMode: 'local',
	                 fieldLabel: getPersonModuleTranslation('PERIOD'),
	                 name: 'PERIOD_NAME',
	                 listeners: {
	                     render: function(combo) {
	                         var store = Ext.create('Academia.store.student.report.DeletedStudentFiltersCommonStore');
	                         combo.bindStore(store);
	                     }
	                 }
	             },{
	                 xtype: 'statusCombo',
	                 name: 'studentStatus',
	                 itemId: 'studentStatus',
	                 fieldLabel: getExaminationTranslation('STUDENT_STATUS'),
	                 value:''
	             }]
			}]
		
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				//formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	//}]
});