/**
 * @author Manisha Wagh
 */
Ext.define('Academia.view.student.studentFeePayerReport.StudentFeeRegistrationResetGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentfeeregistrationresetgrid',
	store: 'student.report.StudentFeesRegistrationResetGridStore',
	title: getCommonTranslation('STUDENT_FEES_REGISTRATION_DETAILS'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemId : 'dockedItemId',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.report.StudentFeesRegistrationResetGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'resetRegistrationBtn',
		tooltip: getCommonTranslation('RESET_REGISTRATION'),
		text: getCommonTranslation('RESET_REGISTRATION')
	}/*,{
		xtype: 'button',
		itemId: 'exportReportItemId',
		disabled:true,
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
	}*/],

	columns: [{
		header :getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentIds',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 1,
		sortable : true
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('BRAND_CAMPUS'),
		dataIndex : 'academyLocationName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('REGISTRATION_STATUS'),
		dataIndex : 'registrationStatus',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('RETURNING_TO_SCHOOL'),
		dataIndex : 'returningToSchool',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('TRANSFERRING_SCHOOL'),
		dataIndex : 'transfferdAcademyLocation',
		flex : 1,
		sortable : true
	}]
});
