/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.student.studentResultReport.MarksObtainedDetailWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.marksobtaineddetailwin',
	title:getExaminationTranslation('MARKS_OBTAINED'),
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: 390,
	width: '60%',
	frame: true,
	items: [{
		 xtype: 'grid',
	     autoScroll:true,
	     name:'marksObtainedDetailGrid',
	     itemId:'marksObtainedDetailGridId',
	     frame:false,
	     border:true,
	    store: 'examinationcenters.evaluation.coverageDetails.StudentMarkObtainedDataStore',
		features: [{
			ftype: 'summary',
			showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
		}],
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'examinationcenters.evaluation.coverageDetails.StudentMarkObtainedDataStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
        columns: [{
	        header: getCBTranslation('structure_level_two_questionNumber'),
	        dataIndex: 'levelName',
	        flex:.2,
	        sortable: true,
			summaryRenderer: function(value, summaryData, dataIndex) {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
	    },{
	        header: getExaminationTranslation('MAXIMUM_MARKS'),
	        dataIndex: 'marks',
	        flex:.1,
	        sortable: true,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					return value;
				} else {
					return "-"
				}                    
			}, 
	     },{
	         header: getExaminationTranslation('OBTAINED_MARKS'),
	         dataIndex: 'obtainedMarks',
	         flex:.1,
	         summaryType: 'sum',
	          sortable: true,
	          renderer:function(value,meta,record){
	        	  if(!isNullOrEmpty(value)) {
						return value;
					} else {
						return "-"
					}                   
				}, 
				summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
					return value.toFixed(2);
				}
	      }]
   },{
	    xtype: 'fieldcontainer',
        width:'100%',
        style:{marginLeft:'-8px'},
        style:{marginTop:'-18px'},
        cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            itemId:'cancelBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
   }]	
});