/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.student.studentResultReport.StudentResultReportGrid', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.studentresultreportgrid',
    reserveScrollbar: true,
    title: getCommonTranslation('STUDENT_RESULT_REPORT'),
    height: 400,
    useArrows: false,
    rootVisible: false, 
    singleExpand: true,
    cls: 'studentassessmentreportgrid no-tree-icon treeGrid',
	border: true, 
    overflowY: 'auto',
    //disableSelection: true,
	frame:false,
	rowLines: true,
	emptyText: '<center>'+getCommonTranslation('NO_RECORDS_FOUND')+'</center>',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS,
		deferEmptyText: false
	},
	store: 'examinationcenters.studentResultReport.StudentResultReportGridStore',
    columns: [{
        xtype: 'treecolumn',
        text: getCommonTranslation('COURSE_CODE_NAME'),
        flex: .2,
        dataIndex: 'treeNode'
    },{
		header:  getExaminationTranslation('MAX_MARKS_GRADE'),
		dataIndex: 'maxMarksOrGrade',
		flex:.1
	},{
		header:  getCommonTranslation('OBTAINED_MARKS_GRADES'),
		dataIndex: 'obtainedMarksGrade',
		flex:.1
	},{
		header:  getCommonTranslation('WEIGHTAGE'),
		dataIndex: 'weightage',
		flex:.1,
		hidden: true
	},{
		header:  getCommonTranslation('EFFECTIVE_MARKS_GRADES'),
		dataIndex: 'effetiveMarksGrade',
		flex:.1,
		hidden: true
	},{
		header:  getCommonTranslation('MODERATION_MARKS_GRADES'),
		dataIndex: 'moderationMarksGrade',
		flex:.1,
		hidden: true
	},{
		header: getCommonTranslation('REMARK'), 
		tooltip: getCommonTranslation('REMARK'), 
 	 	dataIndex: 'typeRemark',  
 	 	flex:.1,
		hidden: true
	}]
});