/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.student.studentprofile.AcademicTopicDocumentsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.academictopicdocumentsgrid',
	store :'student.studentprofile.AcademicTopicDocumentsStore',
	border: true,
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.studentprofile.AcademicTopicDocumentsStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		this.callParent(arguments);
	},

	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH

	},{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'name',
		flex:1,
		renderer:function(value, metaData, record){
			if(record){
				var pathSplit=record.data.path.split('/');
				var newPath=pathSplit[2];
				var newvalue=!isNullOrEmpty(value)?value:newPath;
				return "<a href='#'>"+newvalue+"</a>";
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	}],
	listeners:{
 		cellclick : function(grid,td, cellIndex, record, tr, rowIndex, e, eOpts ) {
			var columnName = grid.ownerCt.columnManager.columns[cellIndex].dataIndex;
			if(columnName == "name"){
				if(e.target.tagName=='A'){
					var documentId=record.get('encryptedDocId');
					if(!isNullOrEmpty(documentId)){
						Ext.Ajax.request({
							type: 'rest',
							url: SERVERURL.CHECK_WHETHER_FILE_FOUND+documentId,
							//params: {documentId:documentId},
							method: 'GET',
							callback : function(opt, success, response){
								if(response.responseText == 'true') {
									var csvForm = Ext.create('Ext.form.Panel'); 
									csvForm.getForm().submit({
										target: '_blank',
										method:'GET',
										params :{
											access_token : Ext.Ajax.defaultHeaders.access_token
										},
										headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
										url: SERVERURL.DOCUMENT_FILE_DOWNLOAD + documentId,
										standardSubmit :true
									});
									showSuccessMessage(getCommonTranslation('ACADEMICS_TOPIC'),getCommonTranslation('ACADEMIC_TOPIC_DOCUMENT_DOWNLOAD_SUCCESSFULLY'));
								} else {
									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('DOCUMENT_NOT_EXIST'));
								}
							}
						});
					}
				}
			}
		}
	}
});