/**
 * This form is used for student and faculty Academic Topic details
 * @author Kuldeep Yadav
 */
Ext.define('Academia.view.student.studentprofile.AcademicsTopicQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.academicstopicquicksearchform',
    frame: false,
    plugins: "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype:'hidden',
        	name:'iscurruntPeriod',
           itemId:'iscurruntPeriodId',
        },
        {
        	xtype:'hidden',
        	name:'iscurruntSection',
           itemId:'iscurruntSectionId',
        },
        
        {
        	xtype:'hidden',
        	name:'exitDate',
           itemId:'exitDateId',
        },
        
        {
        	xtype:'hidden',
        	name:'clickMode',
           itemId:'clickModeId',
        },
        
        
        
        {
            xtype: 'customcombobox',
            name: 'academicTopicId',
            itemId: 'academicTopicItemId',
            fieldLabel: getPersonModuleTranslation('ACADEMICS_TOPIC'),
            editable: false,
          //  allowBlank: false,
            valueField: 'id',
            displayField: 'value',
            store:Ext.create('Academia.store.student.studentprofile.AcademicTopicUserIdStore'),
            queryMode: 'local',
            
            
            /*listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.AcademicTopicStore');
                    combo.bindStore(store);
                }
            }*/
        },{
            xtype: 'customcombobox',
            name: 'academicSubTopicId',
            itemId: 'academicSubTopicItemId',
            fieldLabel: getPersonModuleTranslation('ACADEMICS_SUB_TOPIC'),
            editable: false,
        //    allowBlank: false,
            disabled:true,
            valueField: 'id',
            displayField: 'value',
            store:Ext.create('Academia.store.student.studentprofile.AcademicSubTopicStore'),
            queryMode: 'local',
            /*listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.studentprofile.AcademicSubTopicStore');
                    combo.bindStore(store);
                }
            }*/
        },{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programItemId',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            //editable: false,
         //   allowBlank: false,
            valueField: 'id',
            displayField: 'value',
            queryParam:'name',
            store : Ext.create('Academia.store.student.studentprofile.ProgramAcademicTopicStore'),
          //  queryMode: 'local',
            allowBlank: true,
  			minChars:3,
  			typeAhead:false,
              emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
              forceSelection:true,
//            listeners: {
//                render: function(combo) {
//                    var store = Ext.create('Academia.store.servicerequest.placementrequest.PlacementPrograms');
//                    combo.bindStore(store);
//                }
//            },
              listConfig: {
                  listeners: {
                  beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                    }
                  },
                  loadingText: getCommonTranslation('SEARCHING'),
                  emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                  getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'+
                    '</div>';
                    }
                  }
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batchCombo',
            displayField: 'value',
            valueField: 'id',
//            queryMode: 'local',
            disabled:true,
            editable: false,
        //    allowBlank: false,
            store : Ext.create('Academia.store.student.studentprofile.BatchAcademicTopicStore'),
            //store:'common.BatchesByProgramId',
            fieldLabel: getPersonModuleTranslation('BATCH'),
//            listeners: {
//                render: function(combo) {
//                    var store = Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.ProgramForSectionTransfer');
//                    combo.bindStore(store);
//                }
//            }
        },{
            xtype: 'customcombobox',
            name: 'period',
            itemId: 'periodId',
            fieldLabel: getPersonModuleTranslation('PERIOD'),
            editable: false,
            disabled:true,
          //  allowBlank: false,
            valueField: 'id',
            displayField: 'value',
           
            store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
            /*listeners: {
                render: function(combo) {
                	var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                    combo.bindStore(store);
                }
            }*/
        }]

    },{
        xtype: 'fieldcontainer',
        width: '100%',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
    	layout: 'hbox',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'academicTopicSearchButtonId',
            ui: 'CustomBtnSubmit',
            formBind: true,
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCompletionModuleTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                }
            }
        }]
    }]
});
