/**
 * @author Amit G Salesforce Admission Details
 */
Ext.define('Academia.view.student.studentprofile.StudentSalesforceAdmissionDetailsForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.studentsalesforceadmissiondetailsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    /*initComponent: function() {
    	Ext.apply(this,{
    		customFieldEntity:CONSTANTS.APPLICANT_WORK_EXPERIENCE_CD,
    		columns: 1
    	});
    	           
    	this.callParent(arguments);
    },*/
    items: [{
    	 xtype: 'fieldcontainer',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
         },
      items: [{
		xtype:'displayfield',
		fieldLabel:'<b class="menu-title" style="color:#666666;">'+getCommonTranslation('ADMISSION_DETAILS')+'</b>',
		labelSeparator : '',
		name:'admissionDetails'
      }]	
	},{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256,
            maxLength:255
        },
        style: {
        	'margin-top':'-8px !important'
		},
     items: [{
		  xtype: 'textfield',
		  fieldLabel: getCommonTranslation('PROGRAM'),
		  name: 'programName',
		  itemId: 'programNameId',
		  editable: false,
		  listeners: {
			  afterrender:function(obj,value){
				  setTimeout(function(){
					obj.getEl().dom.setAttribute('data-qtip',obj.getValue());
				  },200);
             }
          }
     },{
    	 xtype: 'textfield',
    	 fieldLabel: getCommonTranslation('BATCH'),
    	 name: 'batchName',
    	 itemId: 'batchNameId',
    	 editable: false,
     },{
    	 xtype: 'textfield',
    	 fieldLabel: getCommonTranslation('PERIOD'),
    	 name: 'periodName',
    	 itemId: 'periodNameId',
    	 editable: false,
     }]
     },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256,
            maxLength:255,
        },
        items: [{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('SALESFORCE_APPLICATION_ID'),
        	name: 'salesForceApplication',
        	itemId :'salesForceApplicationId',
        	editable: false,
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('DELIVERY_MODE'),
        	name: 'deliveryMode',
        	itemId :'deliveryModeId',
        	editable: false,
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('SALESFORCE_APPLICATION_STAGE'),
        	name: 'salesForceStage',
        	itemId :'salesForceStageId',
        	editable: false,
        }]
     },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items:[{
			xtype: 'textarea',
			name: 'articulationAgreementNote',
			itemId:'articulationAgreementNoteId',
			fieldLabel:getCommonTranslation('ARTICULATION_AGREEMENT_NOTE'),
			maxLength:1500
        },{
			xtype: 'textarea',
			name: 'admissionComments',
			itemId:'admissionCommentsId',
			fieldLabel:getCommonTranslation('ADMISSIONS_COMMENTS'),
			maxLength:1500
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
    		xtype: 'checkboxfield',
    		name: 'isDirectEntry',
    		boxLabel: getCommonTranslation('DIRECT_ENTRY'),
    		itemId:'isDirectEntryId',
    		inputValue : true,
    		uncheckedValue: false,
    		labelSeparator : '',
    		style: {
    			//marginTop: '25px'
    		}
    	},{
    		xtype: 'checkboxfield',
    		name: 'isTransferCase',
    		boxLabel: getCommonTranslation('TRANSFER'),
    		itemId:'isTransferCaseId',
    		inputValue : true,
    		uncheckedValue: false,
    		labelSeparator : '',
    		style: {
    			//marginTop: '25px'
    		}
    	},{
    		xtype: 'checkboxfield',
    		name: 'isLateArrival',
    		boxLabel: getCommonTranslation('LATE_ARRIVAL'),
    		itemId:'isLateArrivalId',
    		inputValue : true,
    		uncheckedValue: false,
    		labelSeparator : '',
    		style: {
    			//marginTop: '25px'
    		}
    	}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    	},
    	style: {
    		'margin-top':'10px !important'
		},
    	items: [{
    		xtype:'displayfield',
    		fieldLabel:'<b class="menu-title" style="color:#666666;">'+getCommonTranslation('SUB_PROGRAM')+'</b>',
    		labelSeparator : '',
    		name:'admissionDetails'
    	}]	
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256,
            maxLength:255
        },
        style: {
        	'margin-top':'-8px !important'
		},
        items: [{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('SUB_PROGRAM_1'),
        	name: 'subProgram1',
        	itemId :'subProgramOneId',
        	editable: false,
        	listeners: {
  			  afterrender:function(obj,value){
  				  setTimeout(function(){
  					obj.getEl().dom.setAttribute('data-qtip',obj.getValue());
  				  },200);
               }
            }
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('SUB_PROGRAM_2'),
        	name: 'subProgram2',
        	itemId :'subProgramTwoId',
        	editable: false,
        	listeners: {
  			  afterrender:function(obj,value){
  				  setTimeout(function(){
  					obj.getEl().dom.setAttribute('data-qtip',obj.getValue());
  				  },200);
               }
            }
        }]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    	},
    	style: {
    		'margin-top':'10px !important'
		},
    	items: [{
    		xtype:'displayfield',
    		fieldLabel:'<b class="menu-title" style="color:#666666;">'+getCommonTranslation('SCHOLARSHIP_DETAILS')+'</b>',
    		labelSeparator : '',
    		name:'admissionDetails'
    	}]	
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256,
            maxLength:255
        },
        style: {
        	'margin-top':'-8px !important'
		},
        items: [{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('SCHOLARSHIP_NAME'),
        	name: 'scholarshipName',
        	itemId :'scholarshipNameId',
        	editable: false,
        	listeners: {
  			  afterrender:function(obj,value){
  				  setTimeout(function(){
  					obj.getEl().dom.setAttribute('data-qtip',obj.getValue());
  				  },200);
               }
            }
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('SCHOLARSHIP_DURATION'),
        	name: 'scholarshipDuration',
        	itemId :'scholarshipDurationId',
        	editable: false,
        }]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    	},
    	style: {
    		'margin-top':'10px !important'
		},
    	items: [{
    		xtype:'displayfield',
    		fieldLabel:'<b class="menu-title" style="color:#666666;">'+getCommonTranslation('EC_COMMISSION_DETAILS')+'</b>',
    		labelSeparator : '',
    		name:'admissionDetails'
    	}]	
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
        	labelAlign: 'top',
        	width: 256,
        	maxLength:255

        },
        style: {
        	'margin-top':'-8px !important'
		},
        items: [{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('VERTICAL_AREA_IN_SALESFORCE'),
        	name: 'verticalArea',
        	itemId :'verticalAreaId',
        	editable: false,
        	listeners: {
    			  afterrender:function(obj,value){
    				  setTimeout(function(){
    					obj.getEl().dom.setAttribute('data-qtip',obj.getValue());
    				  },200);
                 }
              }
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('COUNTRY_OF_RECRUITMENT'),
        	name: 'countryName',
        	itemId :'countryNameId',
        	editable: false,
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('APPLICANT_PORTAL_CONTACT'),
        	name: 'applicantPortalContact',
        	itemId :'applicantPortalContactId',
        	editable: false,
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256,
            maxLength:255
        },
        items: [{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('EC_COMMISSION_ACCOUNT'),
        	name: 'ecCommissionAccount',
        	itemId :'ecCommissionAccountId',
        	editable: false,
        	listeners: {
  			  afterrender:function(obj,value){
  				  setTimeout(function(){
  					obj.getEl().dom.setAttribute('data-qtip',obj.getValue());
  				  },200);
               }
            }
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('APPLICATION_OWNER'),
        	name: 'applicationOwner',
        	itemId :'applicationOwnerId',
        	editable: false,
        	listeners: {
  			  afterrender:function(obj,value){
  				  setTimeout(function(){
  					obj.getEl().dom.setAttribute('data-qtip',obj.getValue());
  				  },200);
               }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',  
        style: {
    		'margin-top':'5px !important'
		},
        items: [{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});
