/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.studentPortal.SPStudentAssessmentCommentWindow',{
	extend: 'Ext.window.Window',
	alias: 'widget.spstudentassessmentcommentwindow',
	title:getExaminationTranslation('STUDENT_COMMENT'),
	modal: true,
	maxHeight:500,
	width: 350,
	height:230,
	closeAction: 'destroy',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			defaults: {
				labelAlign: 'top',
				autoScroll:true,
			},
			items: [{
	        	xtype: 'hidden',
	            name: 'stCommentRowIndex', 
	            itemId:'stCommentRowIndex'
            },{
	        	xtype: 'hidden',
	            name: 'stCommentExamResultId', 
	            itemId:'stCommentExamResultId'
            },{
                fieldLabel: getExaminationTranslation('STUDENT_COMMENT'),
	        	xtype: 'textarea',
	            name: 'studentComment',
	            itemId: 'studentComment',
	            width: 300,
	            //enterIsSpecial:true,
	            maxLength:512,
	            //vtype: 'NospaceAsInput'
	        }]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation('OK') ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
					click: function(obj) {
						obj.up('window').close();
					}
                }
            }]
		}]
	}]
});