/**
 * Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.view.studentPortal.attendancereport.StudentAttendanceReportCourseSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentattendancereportcoursesearch',  
	plugins : "formlabelrequired",
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype : 'customcombobox',
			name : 'studentAcademyLocationCourse',
			itemId:'studentAcademyLocationCourse',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
            //allowBlank: false,
            width: 536,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
		xtype : 'fieldcontainer',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				name : 'courseWiseProgram',
				itemId : 'courseWiseProgramId',
				store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				displayField:'valueCode',
				valueField:'id',
				queryParam:'name',
				minChars:3,
				typeAhead:true,
				forceSelection:true,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{code} / {value}'+ 
    	                    '</div>';
    	                }
    	            }
			},{
				xtype: 'customcombobox',
				name: 'courseWiseBatch',
				itemId:'courseWiseBatchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				store: Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				editable:false,
				allowBlank:false
			},{
				xtype: 'customcombobox',
				name: 'courseWisePeriod',
				itemId:'courseWisePeriodId',
				fieldLabel: getExaminationTranslation('PERIOD'),
				store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				disabled:true,
				editable:false,
				allowBlank:false
			}]
		}] },{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
	        	xtype: 'customcombobox',
	        	width: 256,
	            name: 'courseWiseCourseName',
	            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
	        	itemId:'courseWiseCourseNameId',
	        	store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
				valueField: 'courseId',
				displayField: 'courseCodeName',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                forceSelection:true,
    			  listConfig: {
    				  listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	                loadingText: getCommonTranslation('SEARCHING'),
    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	                getInnerTpl: function() {
    	                    return '<div class="search-item">' +
    	                        '{code} / {value}'+ 
    	                    '</div>';
    	                }
    	            }
	           },{
	        	xtype: 'customcombobox',
				name:'courseWiseCoursevarient',
				itemId:'courseWiseCoursevarientId',
				store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				fieldLabel:getCourseTxCommonTranslation('HW_COURSE_VARIANT'),
				valueField: 'id',
				displayField: 'courseVariantCode',
				width: 256,
				disabled:true,
				forceSelection:true,
				typeAhead:true,
				editable:false
	        	}]
		  },{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width: 256
			},
			items:[{
				xtype: 'numberfield',
				fieldLabel: getExaminationTranslation('ATTENDANCE_PERCENTAGE_FROM'),
				name: 'courseWiseAttendancePercentageFrom',
				itemId: 'courseWiseAttendancePercentageFromId',
				minValue : 0,
				maxValue :100,
				hideTrigger: true,
				mouseWheelEnabled:false,
				allowExponential:false,
				keyNavEnabled: false,
				allowDecimals:false,
				//value:0,
				validator : function(val) {
              		 var maxValuefield = this.nextSibling();
              		 var maxValue = maxValuefield.getValue();
              		 if (maxValue != null) {
              			 if (val <= maxValue) {
              				 maxValuefield
              				 .clearInvalid();
              				 return true;
              			 } else {
              				 return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM')+' should be less then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO');
              			 }
              		 } else {
              			 return true;
              		 }
				}
			},{
				xtype: 'numberfield',
				fieldLabel: getExaminationTranslation('ATTENDANCE_PERCENTAGE_TO'),
				name: 'courseWiseAttendancePercentageTo',
				itemId: 'courseWiseAttendancePercentageToId',
				minValue : 1,
				maxValue :100,
				hideTrigger: true,
				mouseWheelEnabled:false,
				allowExponential:false,
				allowDecimals:false,
				keyNavEnabled: false,
				 validator : function(val) {
        	   		 var minValueField =this.previousSibling();
        	   		 var minValue = minValueField
        	   		 .getValue();
        	   		 if (minValue != null && val !=null && val !="") {
        	   			 if (val >= minValue) {
        	   				 minValueField
        	   				 .clearInvalid();
        	   				 return true;
        	   			 } else {
        	   				return getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_TO')+' should be greater then '+getCourseTxCommonTranslation('ATTENDANCE_PERCENTAGE_FROM');
        	   			 }
        	   		 } else {
        	   			 return true;
        	   		 }
        	   	 }
			}]
		  },{
				xtype : 'fieldcontainer',
				width: 'auto',
				layout:'hbox',
				itemId:'dateContainer',
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('START_DATE'),
					name : 'startDate',
					itemId:'startDate',
					vtype : 'daterange',
					endDateField : 'endDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					
				},{
					xtype : 'datefield',
					fieldLabel :getProgramandcourseTranslation('END_DATE'),
					name : 'endDate',
					itemId : 'endDate',
					vtype : 'daterange',
					startDateField : 'startDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					
				}]
			},{
			xtype: 'fieldcontainer',
			width: 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE	        				
			}]
	}] 
	
});