/**
 * Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.view.studentPortal.attendancereport.StudentAttendanceReportSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentattendancereportsearch',  
	plugins : "formlabelrequired",
	frame: false,
	method: 'POST',
	standardSubmit: false,
	cls:'customSearchPanel',
	items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
			xtype : 'customcombobox',
			name : 'studentAcademyLocation',
			itemId:'studentAcademyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'qry',
            //allowBlank: false,
            width: 536,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    }, {
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		}, {
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programBatch_programId',
			store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			displayField:'valueCode',
			valueField:'id',
			width: 536,
			queryParam:'name',
			minChars:3,
  			typeAhead:false,
  			allowBlank:false,
              emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
              forceSelection:true,
			listConfig: {
                listeners: {
                beforeshow: function(picker) {
                  picker.minWidth = picker.up('combobox').getSize().width;
                  }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                  return '<div class="search-item">' +
                  '{code} / {value}'+
                  '</div>';
                  }
                }
		}, {
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			allowBlank:false,
			forceSelection:true,
			editable:false
		}]
	}, {
		xtype : 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodIdItemId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			allowBlank:false,
			typeAhead:true,
			disabled:true,
			editable:false
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 256,
			labelAlign: 'top',
			name : 'sectionId',
			itemId : 'programCoursection_ID',
			store:Ext.create('Academia.store.attendance.AttendanceProgramSectionStore'),
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			disabled:true,
			allowBlank:false,
			forceSelection : true,
			editable:false
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout:'hbox',
		itemId:'dateContainer',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'startDate',
			itemId:'startDate',
			endDateField : 'endDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype : 'daterange'
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'endDate',
			itemId : 'endDate',
			startDateField : 'startDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype : 'daterange'
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}]
});