/**
 * Deepak Nigam
 */
Ext.define('Academia.view.studentPortal.examinationDocuments.GenerateHallTicketStudentPortalGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.generatehallticketstudentportalgrid',
	store: 'personinfo.student.GenerateHallTicketGridStore',
	title: getExaminationTranslation('HALL_TICKETS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false,
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'personinfo.student.GenerateHallTicketGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);
	},
	tbar : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[]
	},{
		xtype: 'button',
		itemId: 'btnDownloadAllHallTickets',
		disabled:true,
		text:getExaminationTranslation('DOWNLOAD_ALL_HALL_TICKETS')
	}],
	columns: [{
		header: getExaminationTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		hidden: true,
		sortable: true
	}, {
		header: getExaminationTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.3,
		sortable: true
	}, {
		header: getExaminationTranslation('TOTAL_OUTSTANDING'),
		dataIndex: 'totalOutstanding',
		flex:.3,
		sortable: true,
		renderer: function(currency,ob,record) {
			if(!isNullOrEmpty(currency)) {
				if(record.get('currencyCode')){
					return record.get('currencyCode')+ ' '+currencyRender(currency);
				}else{
					return "INR. "+currencyRender(currency);
				}
				
			} else {
				return "<b>N/A</b>";
			}
		}
	},{
		header: getExaminationTranslation('HALL_TICKET_NO'),
		dataIndex: 'hallticket',
		flex:.3,
		sortable: true,
		renderer:function(value,meta,record){
			if(value!=null) {
				return '<a href=#>'+value+'</a>';
			}
		}
	}]
});