/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.studentPortal.revaluation.RevalSummaryWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.revalsummarywin',
	title:getExaminationTranslation('Pre-Payment Summary'),
	frame: true,
	autoScroll:false,
	modal:true,
	id:'countWinItemId',
	method: 'POST',
	maxHeight:500,
	width: '60%',
	height:'70%',
//	maxHeight: 600,
	closable:false,
	padding:'10 10 10 10',
	items: [{
		xtype: 'grid',
		autoScroll:true,
		name:'courseGrid',
		itemId:'courseGridItemId',
		frame:false,
		border:true,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		store: 'examinationcenters.evaluation.coverageDetails.CourseCoverageStore',
		maxHeight:350,
		hideHeaders :false,
		width: '96%',
		style:{
			marginBottom:'5px',
		},
		selModel: {
			checkOnly : true, 
			allowDeselect: false
		},
		columns: [{
			header: getExaminationTranslation('COURSE_CODE_NAME'),
			dataIndex: 'courseName',
			flex:.2,
			sortable: true
		},{
			header: getExaminationTranslation('FEE_AMOUNT'),
			dataIndex: 'amount',
			flex:.1,
			sortable: true
		}]
	},{
		xtype: 'fieldcontainer',
		width:'80%',
		layout:'hbox',
		cls:'windowBtnPos',
		style:{
			marginLeft:'10px'
		},
		items: [{
			xtype: 'button',
			itemId:'payNow',
			text: getCommonTranslation('Pay Now'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('OK'),
			itemId:'okBtn',
			ui: 'CustomBtnCancel',
			hidden:true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId:'cancelBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype:'displayfield',
			flex:1,
			style:{
				 marginBottom: '20px'
			},
			name : 'summaryWindMsg',
			itemId : 'summaryWindMsg',
			hidden:true
		}]
	}]
});