/**
 * @author Dharmendra.Goyal
 * 
 */
Ext.define('Academia.view.studentjourneysetup.StudentJourneySetupForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentjourneysetupform',
    plugins : "formlabelrequired",
    //autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		itemId:'translationSearchFilter',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
            name: 'academyLocationCombo',
            itemId:'academyLocationCombo',
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            width: 536,
            typeAhead : false,
            forceSelection:false,
            allowBlank:true,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: 'all',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        },{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'), //Program
			name: 'PROGRAM',
			itemId: 'programId',
			autoload: false,
			store: 'scholarships.AssociateProgramStore',
			valueField: 'id',
			displayField: 'valueCode',
			//queryParam:'qry',
			allowBlank:true,
			disabled:true,
            forceSelection:true,
            hideTrigger:false,
             triggerAction: 'all',
           // minChars:3,
           // emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+ 
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchId',
			store: 'common.CurrentBatchStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:true,
			disabled:true,
			forceSelection:true
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});