Ext.define('Academia.view.sunsuccess.SunSuccessMapFlagsGridView', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.sunsuccessmapflagsgridview',
	store: 'sunsuccess.SunSuccessMapFlagsGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	refreshStoreData:true,
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	/*headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sunsuccessmapflagssearchtab': 1
		}
	},*/
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'sunsuccess.SunSuccessMapFlagsGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnRemoveFlag',
		tooltip: getCommonTranslation('REMOVE_FLAG'),
		text: getCommonTranslation('REMOVE_FLAG'),
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		itemId: 'publishFlag',
//		name:'publishFlag',
		tooltip: getCommonTranslation('PUBLISH_FLAG'),
		text: getCommonTranslation('PUBLISH_FLAG'),
//		store : 'sunsuccess.SunSuccessPublishflagStore',
		disabled:true,
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		itemId: 'sendMessage',
		tooltip: getCommonTranslation('SEND_MESSAGE'),
		text: getCommonTranslation('SEND_MESSAGE'),
		scale: CONSTANTS.BUTTONSIZE
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,true);
		this.callParent(arguments);     
	},
	columns: [{
		header: getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_ID'),
		dataIndex : 'studentCode',
		flex: .1,
		renderer: function(value) {
			if(!Ext.isEmpty(value)) {
				return '<a href="javascript:void(0)">' + value + '</a>';
			}
			return value;
		}
	},{
		header : getPlacementTranslation('PLACEMENT_JOB_APPLICATION_STUDENT_NAME'),
		align: 'left',
		dataIndex : 'studentName',
		flex: .1
	},{
		header : getCommonTranslation('FACULTY'),
		align: 'left',
		dataIndex : 'location',
		flex: .1
	},{
		header : getCommonTranslation('CAMPUS'),
		align: 'left',
		dataIndex : 'campus',
		flex: .1
	},{
		header : getCommonTranslation('PROGRAM'),
		align: 'left',
		dataIndex : 'programName',
		flex: .1
	},{
		header : getCommonTranslation('INTAKE'),
		align: 'left',
		dataIndex : 'batchName',
		flex: .1
	},{
		header : getCommonTranslation('AGGREGATIONS'),
		align: 'left',
		dataIndex : 'aggegationValue',
		flex: .1
	},{
		header : getCommonTranslation('SUN_BI_SUCCESSFLAGS'),
		align: 'left',
		dataIndex : 'flagName',
		flex: .1,
		renderer:function(value, metaData, record){
			return record.get('flagCode')+' / '+value;
		}
	},{
		header : getCommonTranslation('FLAG_COLOR'),
		align: 'left',
		dataIndex : 'flagColor',
		flex: .1
	},{
		header : getCommonTranslation('PUBLISH_STATUSS'),
		align: 'left',
		dataIndex : 'flagPublishStatus',
		flex: .1,
		renderer: function(value) {
			if(value == null) {
				return "";
			}
			else if(value == false){
				return getCommonTranslation('Pending');
			}
			else{
				return getCommonTranslation('Published');
			}
		}
	}, {
		header: getExaminationTranslation('APPOINTMENT'),
		dataIndex : 'bookingId',
		flex: .1,
		renderer: function(value) {
			if(!Ext.isEmpty(value)) {
				return '<a href="javascript:void(0)">' + value + '</a>';
			}
			return value;
		}
	}]
});