/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.survey.sendSurvey.ActivateSurveyPBSWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.activatesurveypbswindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getCommonTranslation('ACTIVATE_SURVEY'),
    width: 550,
    height: 200,
    items: [{
        xtype: 'form',
        itemId: 'activateSurveyForm',
        layout: 'vbox',
        plugins : "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
    			xtype: 'datefield',
    			name: 'fromdatePBS',
    			itemId:'fromdatePBS',
    			allowBlank : false,
    			vtype: 'daterange',
    			endDateField: 'todatePBS',
    			minValue: new Date(),
    			fieldLabel: getAdmissionTranslation('FROM_DATE'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		},{
    			xtype: 'datefield',
    			name: 'todatePBS',
    			itemId:'todatePBS',
    			allowBlank : false,
    			vtype: 'daterange',
    			startDateField: 'fromdatePBS',
    			minValue: new Date(),
    			fieldLabel: getAdmissionTranslation('TO_DATE'),
    			listeners: {
    				render: function(field) {
    					return dateFormatRender(field);
    				}
    			}
    		}]
        },{
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('ACTIVATE_SURVEY'),
				itemId : 'activateSurveyWinPBSBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'activateSurveyWinCancelPBSBtn',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		}]
    }]

});