/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.survey.sendSurvey.CreateSurveyWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.createsurveywindow',
    modal: true,
    resizable: false,
    frame: true,
    title: getCommonTranslation('CREATE_NEW_SURVEY'),
    width: 660,
    height: 420,
    cls: 'create-survey-popup',
    items: [{
        xtype: 'form',
        itemId: 'createSurveyForm',
        plugins : "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
    			xtype: 'customcombobox',
    			name: 'copyFromSurvey',
    			itemId: 'copyFromSurveyItemId',
    			fieldLabel:getCommonTranslation('COPY_FROM'),
    			store: Ext.create('Academia.store.survey.ActiveSurveyListStore'),	    
                valueField:'sid',
                displayField:'surveyls_title',
    			width: 536,
    			disabled:false,
    			typeAhead : true,
    			forceSelection : true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			allowBlank: false,
    			matchFieldWidth:true,
    			listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				}
    			}
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'textfield',
            	name: 'surveyNamePrefix',
            	itemId: 'surveyNamePrefixItemId',
            	allowBlank: false,
            	fieldLabel:getCommonTranslation('SURVEY_NAME_PREFIX'),
            	width: 256
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                width: 536
            },
            items: [{
            	xtype: 'checkboxfield',
    			labelAlign: 'right',
            	name: 'includePeriodCheckBox',
            	itemId: 'includePeriodCheckBoxItemId',
            	boxLabel:getCommonTranslation('INCLUDE_PERIOD_NAME'),
            	inputValue: true
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                width: 536
            },
            items: [{
            	xtype: 'checkboxfield',
    			labelAlign: 'right',
            	name: 'includeFacultyCheckBox',
            	itemId: 'includeFacultyCheckBoxItemId',
            	boxLabel:getCommonTranslation('INCLUDE_FACULTY_NAME'),
            	inputValue: true
            }]
        },{
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('CREATE'),
				itemId : 'createSurveyCreateBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				itemId : 'createSurveyCancelBtn',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		}]
    }]

});