Ext.define('Academia.view.survey.sendSurvey.SendSurveyPBSFilterTwo', {
	extend: 'Ext.form.Panel',
    alias: 'widget.sendsurveypbsfiltertwo',
    plugins : "formlabelrequired",
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
    items: [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'surveyNamePBStwo',
			itemId: 'surveyNamePBSItemIdtwo',
			fieldLabel:getCommonTranslation('SURVEY_NAME'),
			store: Ext.create('Academia.store.survey.SpecificSurveyListStore'),	    
            valueField:'surveyId',
            displayField:'surveyName',
			width: 256,
			disabled:false,
			typeAhead : true,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			matchFieldWidth:true,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				}
			},
			listeners:{
				afterrender: function(combo) {
		            // Ensure that the store is loaded and ready
		            var store = combo.getStore();
		            
		            // Check if the store has not been loaded yet
		            if (store) {
		                store.on('beforeload', function(store) {
		                    store.getProxy().extraParams = {
		                    	isPbs: true // Pass additional params before loading
		                    };
		                });
		            }
		        }
			}
		},{
			xtype : 'customcombobox',
			name : 'academyLocationPBStwo',
			itemId:'academyLocationPBStwo',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.AcademyLocationsByAdmissionStore'),
			valueField : 'id',
			displayField : 'value',
			width: 536,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			editable:false,
			allowBlank: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'programIdPBStwo',
			itemId: 'programIdPBStwo',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:Ext.create('Academia.store.feeandpayment.ALProgramSearchCombo'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			forceSelection:true ,
		    typeAhead:false,
		    disabled: true,
			allowBlank: false,
			editable: false,
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
		},{
			xtype: 'customcombobox',
			name: 'batchIdPBStwo',
			fieldLabel: getCourseTxCommonTranslation('BATCH'),
			itemId:'batchIdPBStwo',
			store:Ext.create('Academia.store.examconcession.ExamConcessionBatchStore'),
			displayField: 'value',
			valueField: 'id',
			disabled : true,
			typeAhead:false,
			forceSelection:true,
			editable : false,
			allowBlank: false
		},{
			xtype: 'customcombobox',
			name: 'periodIdPBStwo',
			itemId:'periodIdPBStwo',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCourseParameterizationPeriodStore'),
			displayField: 'value',
			valueField: 'id',
			disabled : true,
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			editable : false 
		}]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items:[{
			xtype : 'multiselectcombofield',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 256,
			labelAlign: 'top',
			name : 'sectionIdPBStwo',
			itemId : 'sectionIdPBStwo',
			store:Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID'),
			displayField : 'sectionCode',
			valueField : 'sectionId',
			typeAhead : true,
		    disabled:true,
			forceSelection : true,
			editable: false,
			 triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				cls:'commonAutoHeightMultiselectField sendSurveyCourseMultiselect',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('SELECT_DROPDOWN_VALUE'),
				allowBlank: false,
				addAllSelector: false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								try {
									if(items.length==0)
										Ext.select('.x-boundlist-item').elements[0].hidden = true;
									else
										Ext.select('.x-boundlist-item').elements[0].hidden = false;
								}
								catch(err) {
									console.log(err);
								}
					        });
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
		},{
			xtype: 'customcombobox',
			name: 'whetherAnonymousPBSLeveltwo',
			itemId: 'whetherAnonymousPBSLevelItemIdtwo',
			fieldLabel: getCBTranslation('survey_whetherAnonymous'),
			store: Ext.create('Ext.data.Store', {
		        fields: ['code', 'value'],
		        data: [
		            { code: 'Y', value: getCommonTranslation("YES") },  // For Anonymous
		            { code: 'N', value: getCommonTranslation("NO") }    // For Non-Anonymous
		        ]
		    }),	    
            valueField:'code',
            displayField:'value',
			width: 256,
			disabled:false,
			typeAhead : false,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			editable:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	}, {
		xtype:'fieldcontainer',
		width: '100%',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		layout: 'hbox',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchPBSBtntwo',
			ui: 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetPBSBtntwo',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});