/**
 * @author Pritam.Patil
 * This is  User Frequency Search Form
 */
Ext.define('Academia.view.systemUsage.UserFrequencySearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.userfrequencysearchform',
    //autoScroll: true,
    frame: false,
    plugins : "formlabelrequired",
    cls:'customSearchPanel',
    items: [{
    	xtype:'multiselectcombofield',
        fieldLabel: getCommonTranslation('ACADLOCTT'),
        width: 960,
        height:58,
        labelAlign: 'top',
        itemId : 'multiselectAcademyLocationId',
        name: 'ACADEMY_LOCATION_IDS',
        store:'common.AcademyLocationNameSeparated',
        cls:'multiBrandCampusCls',
		valueField : 'id',
		displayField : 'value',
		editable:false,
		cls:'multiBrandCampusCls',
        forceSelection :true,
		allowBlank:false,
		maxLength:15000,
		height:58,
		/*style :{
			  marginLeft: '6px'
		},*/
		autoloadStore: false,
		queryMode:'local',
		  listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			  loadingText: getCommonTranslation('SEARCHING'),
              emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
              getInnerTpl: function() {
                  return '<div class="search-item">' +
                  '{value}'  +
                  '</div>';
              }}
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
       /* style:{
        	marginLeft:'10px'
        },*/
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PORTAL'),
			name : 'portalId',
			itemId : 'portalItemId',
			store : 'reports.userroleprivilege.URPPortalStore',
			valueField : 'id',
			displayField : 'portalName',
			allowBlank : false,
			editable : false,
			forceSelection : true,
		},{
            xtype: 'multiselectcombofield',
            name: 'SYSTEM_MODULES',
            fieldLabel: getCommonTranslation('MODULES'),
            store: 'reports.userroleprivilege.URPModuleStore',
            displayField: 'moduleName',
            valueField: 'id',
            itemId: 'basic_Modules',
            queryMode: 'local',
            width: 536,
            queryMode: 'local',
            minChars:3,
            typeAhead:true,
            triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents  : 'true',
            hideTrigger:false,
            forceSelection:true,
            disabled:true,
            cls:'multiBrandCampusCls commonAutoHeightMultiselectField',
            listConfig: {
            	listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
            	loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{moduleName}'  +
                    '</div>';
                }}
            
        }, {
            xtype: 'customcombobox',
            name: 'SYSTEM_SUB_MODULES',
            fieldLabel: getCommonTranslation('SUB_MODULE'),
            store: 'systemusage.SubMdules',
            displayField: 'moduleName',
            valueField: 'id',
            itemId: 'basic_MenuOptions',
            editable:false,
            disabled:true,
            forceSelection:true
        }]
    },{ 
		xtype:'fieldset',
		title:getFeeAndPaymentCommonTranslation('MORE_FILTERS'),
		collapsible:true,
		collapsed:true,
		width:'100%',
		
        items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
       
        items: [{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('FROM_DATE'),
            name: 'FROM_DATE',
            itemId: 'fromdate',
            vtype: 'daterange',
            endDateField: 'todate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('TO_DATE'),
            name: 'TO_DATE',
            itemId: 'todate',
            vtype: 'daterange',
            startDateField: 'fromdate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        }]
        },{
        xtype: 'fieldcontainer',
        width: '100%',
        fieldLabel : getCommonTranslation('USER_TYPE'),
        labelAlign: 'top',
        layout: {
            type: 'hbox',
            labelAlign: 'top'
        },
       
        items: [{
            xtype: 'radiofield',
            boxLabel: getCommonTranslation('INDIVISUAL'), //Alpha numeric
            name: 'usrRadio',
            inputValue: 'individual',
            itemId: 'individualRadioBtn'
        }, {
            xtype: 'radiofield',
            boxLabel: getCommonTranslation('USER_GROUPS'), //Alpha numeric
            name: 'usrRadio',
            inputValue: 'userGroups',
            itemId: 'userGroupRadioBtn'
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'userTypeIndividualFieldContainer',
        layout: 'hbox',
        defaults: {
            width: 536,
            labelAlign: 'top'
        },
       
        items: [{xtype: 'multiselectcombofield',
         name: 'USER_IDS',
         itemId:'frequency_user_id',
         store:'criteriabuilder.userquicksearch.QuickSearchCode',
         fieldLabel: getCommonTranslation('USER_NAME'),
         width: 536,
         valueField: 'id',
         displayField: 'value',
         queryParam:'code',
         minChars:3,
         typeAhead:true,
         triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
         enableKeyEvents  : 'true',
         hideTrigger:false,
         forceSelection:true,
         hidden:true,
         emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
         listConfig: {
        	 listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
        	 loadingText: getCommonTranslation('SEARCHING'),
             emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
             getInnerTpl: function() {
                 return '<div class="search-item">' +
                 '{code} / {value}'  +
                 '</div>';
             }}
        
        }]},
	 {
        xtype: 'fieldcontainer',
        itemId: 'userGroupFieldContainer',
        layout: 'hbox',
       defaults: {
            width: 536,
            labelAlign: 'top'
        },
       
        items: [{
            xtype: 'multiselectcombofield',
            name: 'USER_GROUP_IDS',
            fieldLabel: getCommonTranslation('USER_GROUP'),
            store: 'systemusage.UserGroupStore',
            displayField: 'userGroupName',
            valueField: 'id',
           editable: false,
           queryMode: 'local',
    		typeAhead: true,
    		hidden:true,
            itemId: 'frequency_user_group1',
            maxLength:400
        }]
    }
        ]}, {
        xtype: 'fieldcontainer',
        width: '100%',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'userFrequencySearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind : true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'userFrequencyClearSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }
    ]
});
