/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.taskmanagement.TMGraphicalReportsFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.tmgraphicalreportsfilter',
    title: getServiceRequestTranslation('TM_GRAPHICAL_REPORT'),
    frame: true,
    plugins: "formlabelrequired",
    border: false,
    autoScroll: false,
    itemId: 'tmgraphicalreportsfilterItemId',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDateItemId',
            vtype: 'daterange',
            endDateField: 'toDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_FROM_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDateItemId',
            vtype: 'daterange',
            startDateField: 'fromDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_TO_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        style: {
            marginLeft: '-11px'
        },
        items: [{
            xtype: 'radiogroup',
            itemId: 'chartGroupItemId',
            style: {
                marginLeft: '8px'
            },
            defaults: {
                flex: .1
            },
            items: [{
                boxLabel: getServiceRequestTranslation('TM_PIE_CHART'),
                name: 'chartName',
                inputValue: 'pieChart',
                checked: true

            }, {
                boxLabel: getServiceRequestTranslation('TM_BAR_CHART'),
                name: 'chartName',
                inputValue: 'barChart'
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('TM_GENERATE'),
            itemId: 'generateTmgraphicalreportsfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetTmgraphicalreportsfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        style: {
            marginLeft: '200px'
        },
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            items: [{
                xtype: 'label',
                itemId: 'chartTextItemId',
                hidden: true,
                text: '',
                style: {
                    color: 'black',
                    'text-align': 'center',
                    'font-weight': 'bold',
                    'font-size': '16px',
                    'margin-top': '13px'
                },
            }, {
                xtype: 'button',
                itemId: 'pieChartExportButtonItemId',
                hidden: true,
                cls: 'CustomToolbarBtnExport',
                iconCls: 'export-image-icon',
                menu: [],
                style: {
                    marginLeft: '30px'
                }
            }, {
                xtype: 'label',
                itemId: 'chartTextBarItemId',
                hidden: true,
                text: '',
                style: {
                    color: 'black',
                    'text-align': 'center',
                    'font-weight': 'bold',
                    'font-size': '16px',
                    'margin-top': '13px'
                },
            }, {
                xtype: 'button',
                itemId: 'barChartExportButtonItemId',
                hidden: true,
                cls: 'CustomToolbarBtnExport',
                iconCls: 'export-image-icon',
                menu: [],
                style: {
                    marginLeft: '30px'
                }
            }]
        }, {
            xtype: 'tmgraphicalreportspiechart',
            itemId: 'tmGraphicalReportsPieChartItemId',
            width: 350,
            minHeight: 300,
            hidden: true,
            store: 'Academia.store.taskmanagement.TMGraphicalReportsStore',
            numericField: 'secondValue',
            categoryField: 'code'
        }, {
            xtype: 'tmgraphicalreportsbarchart',
            itemId: 'tmGraphicalReportsBarChartItemId',
            minWidth: 600,
            height: 320,
            hidden: true,
            columnHeight: 30,
            columnColor: 'Blue',
            store: 'Academia.store.taskmanagement.TMGraphicalReportsStore',
            xAxesNumericField: 'value',
            //xAxesNumericTitle: getAdmissionTranslation('COUNT_OF_ADMISSION'),
            yAxesCategoryField: 'code',
            //yAxesCategoryTitle: getAdmissionTranslation('PROGRAM')
        }]
    }]
});