/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.taskmanagement.TaskManagementForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.taskmanagementform',
    title: getServiceRequestTranslation('TM_ADD_TASKS'),
    frame: true,
    plugins: "formlabelrequired",
    border: false,
    autoScroll: false,
    itemId: 'taskmanagementformItemId',
    cls:'x-form-fixed-footer-parent',
    items: [{
        xtype: 'hidden',
        name: 'id',
        itemId: 'idItemId'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            name: 'minuteSubject',
            itemId: 'minuteSubjectItemId',
            fieldLabel: getServiceRequestTranslation('TITLE'),
            maxLength: 255,
            allowBlank: false,
        }, {
            xtype: 'customcombobox',
            name: 'minuteTakerId',
            itemId: 'minuteTakerIdItemId',
            fieldLabel: getServiceRequestTranslation('TM_TASK_TAKER'),
            store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'codeOrName',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            allowBlank: false,
            forceSelection: true,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'datefield',
            name: 'minuteDate',
            itemId: 'minuteDateItemId',
            fieldLabel: getCommonTranslation('DATE'),
            allowBlank: false,
            vtype: 'daterange',
            maxValue: new Date(),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
                render: function(obj) {
                    obj = dateFormatRender(obj);
                    obj.setValue(new Date());
                }
            }
        }]
    }, {
        xtype: 'taskmanagementtaskgrid',
        style: {
        	'margin-left': '0px !important;'
        }
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        //cls: 'windowBtnPos',
        cls:'form-fixed-footer',
        layout: 'hbox',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SAVE'),
            itemId: 'saveTaskmanagementformItemId',
            formBind: true,
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetTaskmanagementformItemId',
            //buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});