/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.translation.TranslationStructure', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.translationstructure',
	plain: true,
	autoScroll: true,
	items:[{
		xtype:'panel',
		items: [{
			xtype: 'translationfilterform'
		},{
			xtype: 'grid',
			minHeight:250,
			itemId: 'translationGrid',
			store: 'translation.TranslationStore',
			cls: 'translationGridCls',
			border: true,
			frame:false,
			selType:'checkboxmodel',
			title:getCommonTranslation('TRANSLATIONS_LIST'),
			viewConfig: {
				stripeRows: CONSTANTS.STRIPEROWS
			},
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'translationstructure':1
				}
			},
			
			selModel: {
				showHeaderCheckbox: true,
				checkOnly : true,
				allowDeselect: false
			},
			tbar: [{
				xtype : 'button',
				itemId : 'btnAdd',
				tooltip : getCommonTranslation('ADD'),
				iconCls:'icon-addbutton',
				cls:'addbutton',
				disabled: true
			},{
				xtype: 'button',
				text:getCommonTranslation('SAVE'),
				itemId:'saveTranslation',
				tooltip: getCommonTranslation('SAVE'),
				disabled: true
			},{
				xtype: 'button',
				text:getCommonTranslation('REPLACE'),
				itemId:'replaceTranslation',
				tooltip: getCommonTranslation('REPLACE'),
				disabled: true
			},{
				xtype: 'button',
				text:getCommonTranslation('COPY'),
				itemId:'copyTranslation',
				tooltip: getCommonTranslation('COPY'),
				disabled: true
			}],
			columns: [{
				header: getCommonTranslation('OBJECT'),
				dataIndex: 'objectName',
				flex:1,
				sortable:false
			},{
				header: getCommonTranslation('KEY'),
				dataIndex: 'keyName',
				flex:1,
				sortable: false,
				editor: {
					xtype: 'textfield',
					name:'keyName',
					itemId:'keyName',
				}
			}, {
				header: getCommonTranslation('DEFAULT_VALUE'),
				dataIndex: 'defaultValue',
				flex:1,
				sortable: false,
				editor: {
					xtype: 'textfield',
					name:'defaultValue',
					itemId:'defaultValue',
					maxLength:1500
				}
			}, {
				header: getCommonTranslation('CUSTOMER_DEFINE_VALUE'),
				dataIndex: 'customerDefineValue',
				flex:1,
				sortable: false,
				editor: {
					xtype: 'textfield',
					name:'customerDefineValue',
					itemId:'customerDefineValue',
					maxLength:1500
				}
			}],
			plugins: {
				ptype: 'rowediting',
				clicksToEdit: 1
			},
			listeners: {
				beforeedit: function(editor, context) {
					if(!isNullOrEmpty(context.record.get('id'))){
						context.grid.columns[1].getEditor().setReadOnly(true);
						context.grid.columns[2].getEditor().setReadOnly(true);
					}
					else{
						context.grid.columns[1].getEditor().setReadOnly(false);
						context.grid.columns[2].getEditor().setReadOnly(false);
					}
					return context.colIdx !== 0;
				}
			}
		}]
	}]
});