/**
 * sumit.meena
 */
Ext.define('Academia.view.transport.route.RouteForm', {
	    extend : 'Ext.form.FormPanel',
	    alias: 'widget.routeform',
	    modal: true,
	    autoScroll:true,
        bodyPadding: '10 10 10 10',
        frame:true,
        layout: {
            type: 'vbox'
        },
        defaults: {
            labelAlign: 'top',
            autoScroll:true
        },
        style:{
        	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
        },
        plugins:"formlabelrequired",
        standardSubmit: false,
        cls:'x-form-fixed-footer-parent',
        items: [{
           	xtype: 'fieldcontainer',
    		width:'100%',
    		layout: {
    			type: 'hbox'
    		},
    		defaults :{
    			width: 256,
    			labelAlign:'top'
    		},
    		items:[{
    			    xtype:'hidden',
    			    name:'id'
	    		},{
	    			 xtype: 'textfield',
				     name:'routeName',
				     fieldLabel: getTransportTranslation('ROUTE_NAME'),
				     allowBlank: false,
				     maxLength:60
    		     },{
	    			 xtype: 'customcombobox',
				     name:'userType',
				     store:'transport.route.RouteUserTypeStore',
				     itemId:'userTypeItemId',
				     fieldLabel: getTransportTranslation('USER_TYPE'),
				     displayField : 'value',
				     valueField : 'id',
				     allowBlank: false,
				     forceSelection:true
    		     },{
    		    	 xtype: 'customcombobox',
 					 fieldLabel: getTransportTranslation('RESPONSIBLE_PERSON'),
 					 name: 'responsiblePerson',
 					 itemId: 'responsiblePersonItemId',
 					 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
 					// store: 'campaign.UserByAcademyLocation',
 					 //store: 'hostel.roomallocation.UserSmartSearchByUserType',
 					 store: Ext.create('Academia.store.hostel.roomallocation.UserSmartSearchByUserType'),
 					 valueField: 'id',
 					 displayField: 'valueCode',
 					 queryParam:'codeOrName',
 					 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
 					 enableKeyEvents  : 'true',
 					 forceSelection:true,
 					 minChars:3,
 					 typeAhead:false,
 					 hideTrigger:false,
 					 allowBlank: false,
 					 triggerAction: '',
 					 listConfig: {
 						listeners: {
 							beforeshow: function(picker) {
 								picker.minWidth = picker.up('combobox').getSize().width;
 							}
 						},
 						loadingText: getCommonTranslation('SEARCHING'),
 						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 						getInnerTpl: function() {
 							return '<div class="search-item">' +
 							'{value}' +'</div>';
 						}
 					}
    		     },{
	    			 xtype: 'textfield',
				     name:'responsiblePersonExt',
				     fieldLabel: getTransportTranslation('RESPONSIBLE_PERSON'),
				     allowBlank: true,
				     hidden:true
    		     }]
    	   },{
              	xtype: 'fieldcontainer',
        		width:'100%',
        		layout: {
        			type: 'hbox'
        		},
        		defaults :{
        			width: 256,
        			labelAlign:'top'
        		},
        		items:[{
		   		    	 xtype: 'customcombobox',
				    	 name: 'roundTrip',
						 store: 'examinationcenters.YesNo',
						 itemId:'roundTripItemId',
					     fieldLabel: getTransportTranslation('ROUND_TRIP'),
					     displayField : 'value',
					     valueField : 'id',
					     editable : false,
					     allowBlank: false
				     },{
	        			 xtype: 'customcombobox',
					     name:'startsFrom',
					     itemId:'startsFromItemId',
					     store:'transport.route.LocationName',
					     fieldLabel: getTransportTranslation('START_LOCATION'),
					     displayField : 'locationName',
    				     valueField : 'id',
    				     editable : false,
					     allowBlank: false
        		     },{
    	    			 xtype: 'customcombobox',
    				     name:'endsAt',
    				     itemId:'endsAtItemId',
    				     store:'transport.route.LocationName',
    				     fieldLabel: getTransportTranslation('END_LOCATION'),
    				     displayField : 'locationName',
    				     valueField : 'id',
    				     editable : false,
    				     allowBlank: false
        		     }]
        	  },{
                	xtype: 'fieldcontainer',
            		width:'100%',
            		layout: {
            			type: 'hbox'
            		},
            		defaults :{
            			width: 256,
            			labelAlign:'top'
            		},
            		items:[{
    	        			 xtype: 'numberfield',
    					     name:'distanceInKm',
    					     fieldLabel: getTransportTranslation('DISTANCE_IN_KMS'),
    					     itemId:'distanceInKmItemId',
    					     minValue : 0,
    			             hideTrigger:true,
    			             readOnly:true,
    			             disabled:true,
    					     allowBlank: false
            		     },{
        	    			 xtype: 'customcombobox',
        				     name:'isActive',
        				     store:'examinationcenters.YesNo',
        				     fieldLabel: getTransportTranslation('IS_ACTIVE'),
        				     displayField : 'value',
        				     editable : false,
        				     valueField : 'id',
        				     allowBlank: false
            		     }]
            	  },{
					xtype:'fieldcontainer',
					itemId:'stopPanelId',
					items:[{
						xtype : 'fieldcontainer',
						width: '100%',
						itemId:'stopContainer',
						layout : 'hbox',
						defaults: {
			                width: 256,
			                labelAlign: 'top'
			            },
						items : [{
							xtype : 'customcombobox',
							name : 'startLocation',		
							store: 'transport.route.LocationName',
							displayField: 'locationName',
							valueField: 'id',
							editable : false,
							fieldLabel:getTransportTranslation('STOP_LOCATION'),
							allowBlank:false,
							readOnly:true
						},{
							xtype : 'numberfield',
							name : 'startDistance',		
							fieldLabel:getTransportTranslation('DISTANCE'),
							value:0,
							minValue : 0,
			                hideTrigger:true,
							readOnly:true,
							allowBlank:false
						},{
							xtype: 'button',
							itemId: 'stopBtn',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'24px'
							}
						 } 
					]}
			    ]
            },{
            	xtype: 'fieldcontainer',
        		width:'100%',
        		layout: {
        			type: 'hbox'
        		},
        		defaults :{
        			width: 256,
        			labelAlign:'top'
        		},
        		items:[{
	        			xtype : 'customcombobox',
						name : 'endLocation',		
						store: 'transport.route.LocationName',
						displayField: 'locationName',
						valueField: 'id',
						editable : false,
						allowBlank:false,
						readOnly:true
					},{
						xtype : 'numberfield',
						name : 'endDistance',		
						itemId:'endDistanceItemId',
						minValue : 0,
		                hideTrigger:true,
						allowBlank:false
        		     }]
        	  },{
	        	xtype: 'fieldcontainer',
	            width:'100%',
	            cls:'form-fixed-footer',
	            items: [{
	                xtype: 'button',
	                action : 'Submit',
	                text: getCommonTranslation('SAVE'),
	                itemId: 'btnSave',
	                ui: 'CustomBtnSubmit',
	                scale: CONSTANTS.BUTTONSIZE,
	                formBind: true
	            }, {
	                xtype: 'button',
	                text: getCommonTranslation('RESET'),
	                itemId: 'btnReset',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
        }]
});